/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor.reload;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class SelectionContext<V extends ISelectionProvider, T> {
    private List<T> selection = Lists.newArrayList();

    public SelectionContext(V structuredSelectionProvider) {
        for (Object next : ((IStructuredSelection)structuredSelectionProvider.getSelection()).toList()) {
            T token = this.token(next);
            if (token == null) continue;
            this.selection.add(token);
        }
    }

    public void restore(V structuredSelectionProvider) {
        ArrayList select = Lists.newArrayListWithCapacity((int)this.selection.size());
        for (T next : this.selection) {
            Object resolved = this.resolve(next);
            if (resolved == null) continue;
            select.add(resolved);
        }
        this.setSelection(structuredSelectionProvider, select);
    }

    T token(Object selectableElement) {
        Object deresolved = this.deresolveSelectableElement(selectableElement);
        return deresolved == null ? null : (T)this.getToken(deresolved);
    }

    protected Object deresolveSelectableElement(Object selectableElement) {
        return selectableElement;
    }

    protected abstract T getToken(Object var1);

    Object resolve(T token) {
        Object deresolved = this.resolveToken(token);
        return deresolved == null ? null : this.resolveSelectableElement(deresolved);
    }

    protected Object resolveSelectableElement(Object deresolved) {
        return deresolved;
    }

    protected abstract Object resolveToken(T var1);

    protected void setSelection(V structuredSelectionProvider, List<?> selection) {
        structuredSelectionProvider.setSelection((ISelection)new StructuredSelection(selection));
    }
}

