/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editor.reload;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.editor.reload.SelectionContext;

public abstract class TreeViewerContext<T>
extends SelectionContext<AbstractTreeViewer, T> {
    private List<T> expandedNodes = Lists.newArrayList();

    public TreeViewerContext(AbstractTreeViewer viewer) {
        super(viewer);
        Object[] objectArray = viewer.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            Object token = this.token(next);
            if (token != null) {
                this.expandedNodes.add(token);
            }
            ++n2;
        }
    }

    @Override
    public void restore(AbstractTreeViewer viewer) {
        ArrayList expand = Lists.newArrayListWithCapacity((int)this.expandedNodes.size());
        for (T next : this.expandedNodes) {
            Object resolved = this.resolve(next);
            if (resolved == null) continue;
            expand.add(resolved);
        }
        this.setExpandedElements(viewer, expand);
        super.restore(viewer);
    }

    @Override
    protected void setSelection(AbstractTreeViewer viewer, List<?> selection) {
        viewer.setSelection((ISelection)new StructuredSelection(selection), true);
    }

    protected void setExpandedElements(AbstractTreeViewer viewer, Collection<?> toExpand) {
        viewer.setExpandedElements(toExpand.toArray());
    }
}

