/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.editorsfactory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.editorsfactory.IEditorIconFactory;
import org.eclipse.papyrus.infra.core.editorsfactory.IEditorIconFactoryExtended;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistryExtended;
import org.eclipse.swt.graphics.Image;

public class PageIconsRegistry
implements IPageIconsRegistryExtended {
    protected List<IEditorIconFactory> pageIcons = new ArrayList<IEditorIconFactory>();

    @Override
    public Image getEditorIcon(Object pageIdentifier) {
        for (IEditorIconFactory factory : this.getPageIcons()) {
            if (!factory.isPageModelFactoryFor(pageIdentifier)) continue;
            return factory.getEditorIcon(pageIdentifier);
        }
        return null;
    }

    protected List<IEditorIconFactory> getPageIcons() {
        return this.pageIcons;
    }

    public void add(IEditorIconFactory editorIconFactory) {
        if (editorIconFactory == null) {
            throw new RuntimeException("Parameter should not be null.");
        }
        this.pageIcons.add(editorIconFactory);
    }

    public void remove(IEditorIconFactory editorIconFactory) {
        this.pageIcons.remove(editorIconFactory);
    }

    @Override
    public String getEditorURLIcon(Object model) {
        for (IEditorIconFactory factory : this.getPageIcons()) {
            if (!factory.isPageModelFactoryFor(model) || !(factory instanceof IEditorIconFactoryExtended)) continue;
            return ((IEditorIconFactoryExtended)factory).getURLMainIcon(model);
        }
        return "";
    }

    @Override
    public void dispose() {
        for (IEditorIconFactory factory : this.pageIcons) {
            factory.dispose();
        }
    }
}

