/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelSnippetList;

public abstract class AbstractModel
implements IModel {
    public static final String ENCODING = "UTF-8";
    protected ModelSet modelSet;
    protected ModelSnippetList snippets = new ModelSnippetList();
    protected List<String> afterLoadModelIdentifiers;
    protected List<String> unloadBeforeModelIdentifiers;

    @Override
    public void init(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    protected ModelSet getModelManager() {
        return this.modelSet;
    }

    protected ResourceSet getResourceSet() {
        return this.modelSet;
    }

    @Override
    public abstract String getIdentifier();

    @Override
    public void addModelSnippet(IModelSnippet snippet) {
        this.snippets.add(snippet);
    }

    @Override
    public void setAfterLoadModelDependencies(List<String> afterLoadModelIdentifiers) {
        this.afterLoadModelIdentifiers = afterLoadModelIdentifiers;
    }

    @Override
    public List<String> getAfterLoadModelIdentifiers() {
        return this.afterLoadModelIdentifiers;
    }

    @Override
    public void setBeforeUnloadDependencies(List<String> unloadBeforeModelIdentifiers) {
        this.unloadBeforeModelIdentifiers = unloadBeforeModelIdentifiers;
    }

    @Override
    public List<String> getUnloadBeforeModelIdentifiers() {
        return this.unloadBeforeModelIdentifiers;
    }

    @Override
    public void unload() {
        this.modelSet = null;
        this.snippets.clear();
    }

    @Override
    public boolean isModelFor(Object element) {
        return false;
    }

    @Override
    public void cleanModel(Set<URI> resourcesToDelete) {
    }
}

