/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import java.io.IOException;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.core.lifecycleevents.LifeCycleEventsProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.core.services.EditorLifecycleManager;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;

public class SaveLayoutBeforeClose
implements IService {
    private ServicesRegistry registry;
    private EditorLifecycleManager lifecycleManager;
    private EditorLifecycleEventListener lifecycleListener;

    @Override
    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
        this.installSaveOnClose();
    }

    protected void installSaveOnClose() {
        try {
            this.lifecycleManager = this.registry.getService(EditorLifecycleManager.class);
            if (this.lifecycleManager == null) {
                return;
            }
        }
        catch (ServiceException ex) {
            return;
        }
        this.lifecycleListener = new EditorLifecycleEventListener(){

            @Override
            public void postInit(IMultiDiagramEditor editor) {
            }

            @Override
            public void postDisplay(IMultiDiagramEditor editor) {
            }

            @Override
            public void beforeClose(IMultiDiagramEditor editor) {
                SaveLayoutBeforeClose.this.saveBeforeClose(editor);
            }
        };
        this.lifecycleManager.addEditorLifecycleEventsListener(this.lifecycleListener);
    }

    protected void saveBeforeClose(IMultiDiagramEditor editor) {
        ModelSet modelSet;
        if (editor.isDirty()) {
            return;
        }
        LifeCycleEventsProvider internalLifecycleEventsProvider = null;
        try {
            modelSet = this.registry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            return;
        }
        try {
            ILifeCycleEventsProvider eventsProvider = this.registry.getService(ILifeCycleEventsProvider.class);
            if (eventsProvider instanceof LifeCycleEventsProvider) {
                internalLifecycleEventsProvider = (LifeCycleEventsProvider)eventsProvider;
            }
        }
        catch (ServiceException eventsProvider) {
            // empty catch block
        }
        SashModel sashModel = (SashModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
        try {
            DoSaveEvent event = new DoSaveEvent(this.registry, editor, true);
            internalLifecycleEventsProvider.fireAboutToDoSaveEvent(event);
            internalLifecycleEventsProvider.fireDoSaveEvent(event);
            sashModel.saveModel();
            internalLifecycleEventsProvider.firePostDoSaveEvent(event);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void disposeService() throws ServiceException {
        this.registry = null;
        if (this.lifecycleManager != null) {
            this.lifecycleManager.removeEditorLifecycleEventsListener(this.lifecycleListener);
            this.lifecycleListener = null;
            this.lifecycleManager = null;
        }
    }
}

