/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;

public class AdapterUtils {
    private AdapterUtils() {
    }

    public static <T> Optional<T> adapt(Object object, Class<T> type) {
        Optional result = Optional.absent();
        if (object instanceof IAdaptable) {
            result = result.or(AdapterUtils.getIntrinsicAdapter((IAdaptable)object, type));
        }
        if (!result.isPresent() && !(result = result.or(AdapterUtils.getExtrinsicAdapter(object, type))).isPresent() && object instanceof Notifier) {
            result = result.or(AdapterUtils.getEMFAdapter((Notifier)object, type));
        }
        return result;
    }

    private static <T> Optional<T> getIntrinsicAdapter(IAdaptable adaptable, Class<T> type) {
        Object result = null;
        Object attempt = adaptable.getAdapter(type);
        if (type.isInstance(attempt)) {
            result = type.cast(attempt);
        }
        return Optional.fromNullable(result);
    }

    private static <T> Optional<T> getExtrinsicAdapter(Object object, Class<T> type) {
        Object result = null;
        Object attempt = Platform.getAdapterManager().getAdapter(object, type);
        if (type.isInstance(attempt)) {
            result = type.cast(attempt);
        }
        return Optional.fromNullable(result);
    }

    private static <T> Optional<T> getEMFAdapter(Notifier notifier, Class<T> type) {
        return Iterables.tryFind((Iterable)Iterables.filter((Iterable)notifier.eAdapters(), type), (Predicate)Predicates.alwaysTrue());
    }

    public static <T> T adapt(Object object, Class<T> type, T defaultAdapter) {
        Optional<T> adapter;
        Object result = defaultAdapter;
        if (object != null && (adapter = AdapterUtils.adapt(object, type)).isPresent()) {
            result = adapter.get();
        }
        return result;
    }
}

