/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.emf.readonly.Activator;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadOnlyCache
extends TransactionalEditingDomainListenerImpl {
    private static final ThreadLocal<ReadOnlyCache> context = new ThreadLocal();
    private final TransactionalEditingDomain transactionalEditingDomain;
    private AtomicInteger activeTransactionCount = new AtomicInteger();
    private Map<Set<URI>, ReadOnlyState> resourceReadOnlyStates;
    private Map<EObject, ReadOnlyState> objectReadOnlyStates;
    private ConcurrentMap<AbstractReadOnlyHandler, ConcurrentMap<URI, ReadOnlyState>> handlerResourceReadOnlyCache;

    static {
        AbstractReadOnlyHandler.setResourceReadOnlyCacheProvider((AbstractReadOnlyHandler.ResourceReadOnlyCache.Provider)new ResourceReadOnlyCacheProvider());
    }

    ReadOnlyCache(TransactionalEditingDomain transactionalEditingDomain) {
        this.transactionalEditingDomain = transactionalEditingDomain;
    }

    static ReadOnlyCache create(ReadOnlyManager manager, EditingDomain domain) {
        TransactionalEditingDomain ted;
        TransactionalEditingDomain.Lifecycle lifecycle;
        ReadOnlyCache result = null;
        if (domain instanceof TransactionalEditingDomain && (lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)(ted = (TransactionalEditingDomain)domain), TransactionalEditingDomain.Lifecycle.class)) != null) {
            result = new ReadOnlyCache(ted);
            lifecycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)result);
            if (Platform.inDebugMode()) {
                Activator.log.info("Read-only cache activated for editing domain " + domain);
            }
        }
        if (result == null) {
            result = Dud.INSTANCE;
        }
        return result;
    }

    public void dispose() {
        if (this.transactionalEditingDomain != null) {
            this.editingDomainDisposing(new TransactionalEditingDomainEvent(this.transactionalEditingDomain, 32));
            TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.transactionalEditingDomain, TransactionalEditingDomain.Lifecycle.class);
            if (lifecycle != null) {
                lifecycle.removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
            }
        }
    }

    public Optional<Boolean> getResources(Set<ReadOnlyAxis> axes, Set<URI> uris) {
        Map<Set<URI>, ReadOnlyState> resourceReadOnlyStates = this.getResourceReadOnlyStates();
        ReadOnlyState state = resourceReadOnlyStates == null ? null : resourceReadOnlyStates.get(uris);
        return state == null ? null : (Optional)state.get(axes);
    }

    public Optional<Boolean> getObject(Set<ReadOnlyAxis> axes, EObject object) {
        Map<EObject, ReadOnlyState> objectReadOnlyStates = this.getObjectReadOnlyStates();
        ReadOnlyState state = objectReadOnlyStates == null ? null : objectReadOnlyStates.get(object);
        return state == null ? null : (Optional)state.get(axes);
    }

    public void putResources(Set<ReadOnlyAxis> axes, Set<URI> uris, Optional<Boolean> readonly) {
        Map<Set<URI>, ReadOnlyState> resourceReadOnlyStates = this.getResourceReadOnlyStates();
        if (resourceReadOnlyStates != null) {
            ReadOnlyState state = resourceReadOnlyStates.get(uris);
            if (state == null) {
                state = new ReadOnlyState();
                resourceReadOnlyStates.put(uris, state);
            }
            state.put(axes, readonly);
        }
    }

    public void putObject(Set<ReadOnlyAxis> axes, EObject object, Optional<Boolean> readonly) {
        Map<EObject, ReadOnlyState> objectReadOnlyStates = this.getObjectReadOnlyStates();
        if (objectReadOnlyStates != null) {
            ReadOnlyState state = objectReadOnlyStates.get(object);
            if (state == null) {
                state = new ReadOnlyState();
                objectReadOnlyStates.put(object, state);
            }
            state.put(axes, readonly);
        }
    }

    public synchronized void clear() {
        if (this.resourceReadOnlyStates != null) {
            this.resourceReadOnlyStates.clear();
        }
        if (this.objectReadOnlyStates != null) {
            this.objectReadOnlyStates.clear();
        }
        if (this.handlerResourceReadOnlyCache != null) {
            this.handlerResourceReadOnlyCache.clear();
        }
    }

    private Map<Set<URI>, ReadOnlyState> getResourceReadOnlyStates() {
        if (this.activeTransactionCount.get() > 0) {
            this.initCache();
            return this.resourceReadOnlyStates;
        }
        return null;
    }

    private Map<EObject, ReadOnlyState> getObjectReadOnlyStates() {
        if (this.activeTransactionCount.get() > 0) {
            this.initCache();
            return this.objectReadOnlyStates;
        }
        return null;
    }

    private ConcurrentMap<AbstractReadOnlyHandler, ConcurrentMap<URI, ReadOnlyState>> getHandlerResourceReadOnlyCache() {
        if (this.activeTransactionCount.get() > 0) {
            this.initCache();
            return this.handlerResourceReadOnlyCache;
        }
        return null;
    }

    private synchronized void initCache() {
        if (this.resourceReadOnlyStates == null) {
            this.resourceReadOnlyStates = Maps.newHashMap();
            this.objectReadOnlyStates = Maps.newHashMap();
            this.handlerResourceReadOnlyCache = Maps.newConcurrentMap();
        }
    }

    public void transactionStarted(TransactionalEditingDomainEvent event) {
        if (!TransactionHelper.isReadOnlyCacheDisabled((Transaction)event.getTransaction())) {
            this.activeTransactionCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionClosed(TransactionalEditingDomainEvent event) {
        if (!TransactionHelper.isReadOnlyCacheDisabled((Transaction)event.getTransaction()) && this.activeTransactionCount.decrementAndGet() <= 0) {
            ReadOnlyCache readOnlyCache = this;
            synchronized (readOnlyCache) {
                this.resourceReadOnlyStates = null;
                this.objectReadOnlyStates = null;
                this.handlerResourceReadOnlyCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
        this.activeTransactionCount.set(0);
        ReadOnlyCache readOnlyCache = this;
        synchronized (readOnlyCache) {
            this.resourceReadOnlyStates = null;
            this.objectReadOnlyStates = null;
            this.handlerResourceReadOnlyCache = null;
        }
        if (Platform.inDebugMode()) {
            Activator.log.info("Read-only cache deactivated for editing domain " + event.getSource());
        }
    }

    void run(Runnable operation) {
        ReadOnlyCache previous = context.get();
        context.set(this);
        try {
            operation.run();
        }
        finally {
            if (previous == null) {
                context.remove();
            } else {
                context.set(previous);
            }
        }
    }

    AbstractReadOnlyHandler.ResourceReadOnlyCache getResourceReadOnlyCache(final AbstractReadOnlyHandler handler) {
        return new AbstractReadOnlyHandler.ResourceReadOnlyCache(){

            public Optional<Boolean> get(Set<ReadOnlyAxis> axes, URI resourceURI) {
                ReadOnlyState state;
                Map forHandler;
                ConcurrentMap handlerResourceReadOnlyCache = ReadOnlyCache.this.getHandlerResourceReadOnlyCache();
                Optional result = handlerResourceReadOnlyCache == null ? null : ((forHandler = (Map)handlerResourceReadOnlyCache.get(handler)) == null ? null : ((state = (ReadOnlyState)forHandler.get(resourceURI)) == null ? null : (Optional)state.get(axes)));
                return result;
            }

            public void put(Set<ReadOnlyAxis> axes, URI resourceURI, Optional<Boolean> readOnlyState) {
                ConcurrentMap handlerResourceReadOnlyCache = ReadOnlyCache.this.getHandlerResourceReadOnlyCache();
                if (handlerResourceReadOnlyCache != null) {
                    ReadOnlyState state;
                    ConcurrentMap forHandler = (ConcurrentMap)handlerResourceReadOnlyCache.get(handler);
                    if (forHandler == null) {
                        handlerResourceReadOnlyCache.putIfAbsent(handler, Maps.newConcurrentMap());
                        forHandler = (ConcurrentMap)handlerResourceReadOnlyCache.get(handler);
                    }
                    if ((state = (ReadOnlyState)forHandler.get(resourceURI)) == null) {
                        forHandler.putIfAbsent(resourceURI, new ReadOnlyState());
                        state = (ReadOnlyState)forHandler.get(resourceURI);
                    }
                    state.put(axes, readOnlyState);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Dud
    extends ReadOnlyCache {
        static final Dud INSTANCE = new Dud();

        private Dud() {
            super(null);
        }

        @Override
        public Optional<Boolean> getResources(Set<ReadOnlyAxis> axes, Set<URI> uris) {
            return null;
        }

        @Override
        public Optional<Boolean> getObject(Set<ReadOnlyAxis> axes, EObject object) {
            return null;
        }

        @Override
        public void putResources(Set<ReadOnlyAxis> axes, Set<URI> uris, Optional<Boolean> readonly) {
        }

        @Override
        public void putObject(Set<ReadOnlyAxis> axes, EObject object, Optional<Boolean> readonly) {
        }

        @Override
        AbstractReadOnlyHandler.ResourceReadOnlyCache getResourceReadOnlyCache(AbstractReadOnlyHandler handler) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadOnlyState
    extends HashMap<Set<ReadOnlyAxis>, Optional<Boolean>> {
        private static final long serialVersionUID = 1L;

        private ReadOnlyState() {
        }
    }

    private static class ResourceReadOnlyCacheProvider
    implements AbstractReadOnlyHandler.ResourceReadOnlyCache.Provider {
        private ResourceReadOnlyCacheProvider() {
        }

        public AbstractReadOnlyHandler.ResourceReadOnlyCache get(AbstractReadOnlyHandler handler) {
            AbstractReadOnlyHandler.ResourceReadOnlyCache result = null;
            ReadOnlyCache cache = (ReadOnlyCache)((Object)context.get());
            if (cache != null) {
                result = cache.getResourceReadOnlyCache(handler);
            }
            return result;
        }
    }
}

