/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Objects;
import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyTester
extends PropertyTester {
    public static final String IS_READ_ONLY = "isReadOnly";
    public static final String CAN_MAKE_WRITABLE = "canMakeWritable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            Iterator objects = ((IStructuredSelection)receiver).iterator();
            if (IS_READ_ONLY.equals(property)) {
                return this.testIsReadOnly(objects, this.asBoolean(expectedValue));
            }
            if (CAN_MAKE_WRITABLE.equals(property)) {
                return this.canMakeWritable(objects, this.asBoolean(expectedValue));
            }
        }
        return false;
    }

    protected Boolean asBoolean(Object expectedValue) {
        return expectedValue instanceof Boolean ? (Boolean)expectedValue : true;
    }

    protected boolean testIsReadOnly(Iterator<?> objects, Boolean expectedValue) {
        while (objects.hasNext()) {
            EObject eObject;
            EditingDomain domain;
            Object businessObject = BusinessModelResolver.getInstance().getBusinessModel(objects.next());
            if (!(businessObject instanceof EObject) || (domain = EMFHelper.resolveEditingDomain((EObject)(eObject = (EObject)businessObject))) == null) continue;
            return Objects.equal((Object)ReadOnlyManager.getReadOnlyHandler(domain).isReadOnly(ReadOnlyAxis.anyAxis(), eObject).or((Object)false), (Object)expectedValue);
        }
        return false;
    }

    protected boolean canMakeWritable(Iterator<?> objects, Boolean expectedValue) {
        while (objects.hasNext()) {
            EObject eObject;
            EditingDomain domain;
            Object businessObject = BusinessModelResolver.getInstance().getBusinessModel(objects.next());
            if (!(businessObject instanceof EObject) || (domain = EMFHelper.resolveEditingDomain((EObject)(eObject = (EObject)businessObject))) == null) continue;
            IReadOnlyHandler2 handler = ReadOnlyManager.getReadOnlyHandler(domain);
            boolean isAlreadyOrCanMakeWritable = (Boolean)handler.isReadOnly(ReadOnlyAxis.anyAxis(), eObject).or((Object)false) == false || (Boolean)handler.canMakeWritable(ReadOnlyAxis.anyAxis(), eObject).or((Object)false) != false;
            return Objects.equal((Object)isAlreadyOrCanMakeWritable, (Object)expectedValue);
        }
        return false;
    }
}

