/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.adapters;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;

public class EObjectAdapterFactory
implements IAdapterFactory {
    private final Class<?>[] adapterTypes = new Class[]{IAtomicOperationExecutor.class};

    public Object getAdapter(Object adaptable, Class adapterType) {
        EMFAtomicOperationExecutor result = null;
        if (adaptable instanceof EObject && adapterType == IAtomicOperationExecutor.class) {
            ResourceSet rset;
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)((EObject)adaptable));
            if (domain == null && (rset = NestedEditingDialogContext.getInstance().getResourceSet()) != null) {
                domain = TransactionUtil.getEditingDomain((ResourceSet)rset);
            }
            if (domain != null) {
                result = new EMFAtomicOperationExecutor(domain);
            }
        }
        return result;
    }

    public Class[] getAdapterList() {
        return this.adapterTypes;
    }

    private static final class EMFAtomicOperationExecutor
    extends IAtomicOperationExecutor.Default {
        private final TransactionalEditingDomain domain;

        EMFAtomicOperationExecutor(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        public void execute(final Runnable operation, String label) {
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain, label){

                protected void doExecute() {
                    operation.run();
                }
            });
        }
    }
}

