/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.DecoratingCustomizedLabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.ResolvingCustomizedLabelProvider;
import org.eclipse.papyrus.emf.facet.util.emf.core.internal.EMFUtils;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.providers.StandardEMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.IDetailLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.IQualifierLabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFLabelProvider
extends ResolvingCustomizedLabelProvider
implements IDetailLabelProvider,
IQualifierLabelProvider {
    protected ILabelProvider baseEMFLabelProvider = new StandardEMFLabelProvider();

    public EMFLabelProvider() {
        super((ICustomizedLabelProvider)new DecoratingCustomizedLabelProvider(Activator.getDefault().getCustomizationManager()));
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof TreeElement) {
            return super.getText(element);
        }
        EObject eObject = EMFHelper.getEObject(element);
        if (eObject != null) {
            return this.getText(eObject);
        }
        if (element instanceof IStructuredSelection) {
            return this.getText((IStructuredSelection)element);
        }
        return element.toString();
    }

    protected String getText(EObject element) {
        return this.baseEMFLabelProvider.getText((Object)element);
    }

    protected String getText(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return "";
        }
        if (selection.size() == 1) {
            return this.getText(selection.getFirstElement());
        }
        List selectionAsList = selection.toList();
        String str = "";
        int i = 0;
        while (i < selectionAsList.size()) {
            String txt = this.getText(selectionAsList.get(i));
            if (txt != null) {
                str = String.valueOf(str) + txt;
            }
            if (i < selectionAsList.size() - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        return str;
    }

    public Image getImage(Object element) {
        if (element instanceof TreeElement) {
            return super.getImage(element);
        }
        EObject eObject = EMFHelper.getEObject(element);
        if (eObject != null) {
            return this.getImage(eObject);
        }
        if (element instanceof IStructuredSelection) {
            return this.getImage((IStructuredSelection)element);
        }
        return null;
    }

    protected Image getImage(EObject eObject) {
        return this.baseEMFLabelProvider.getImage((Object)eObject);
    }

    protected Image getImage(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection.size() == 1) {
            return this.getImage(selection.getFirstElement());
        }
        List selectionAsList = selection.toList();
        HashSet<EObject> selectedEObject = new HashSet<EObject>();
        boolean isEObjectSelection = true;
        for (Object current : selectionAsList) {
            EObject obj = EMFHelper.getEObject(current);
            if (obj != null) {
                selectedEObject.add(obj);
                continue;
            }
            isEObjectSelection = false;
        }
        if (isEObjectSelection) {
            if (selectedEObject.size() == 1 || this.hasCommonImage(selectedEObject)) {
                return this.getImage(selectedEObject.toArray()[0]);
            }
            EClass common = EMFUtils.computeLeastCommonSupertype(this.getEClasses(selectedEObject));
            if (!common.isAbstract()) {
                EObject instance = common.getEPackage().getEFactoryInstance().create(common);
                return this.getNonCommonIcon(instance);
            }
        } else {
            selectedEObject.size();
        }
        return null;
    }

    protected boolean hasCommonImage(Collection<?> objects) {
        if (!objects.isEmpty()) {
            Image lastImage = this.getImage(objects.toArray()[0]);
            for (Object current : objects) {
                if (lastImage == this.getImage(current)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected Image getNonCommonIcon(Object commonObject) {
        return this.getImage(commonObject);
    }

    private Set<EClass> getEClasses(Collection<EObject> objects) {
        HashSet<EClass> eclasses = new HashSet<EClass>();
        for (EObject current : objects) {
            eclasses.add(current.eClass());
        }
        return eclasses;
    }

    public String getDetail(Object object) {
        object = EMFHelper.getEObject(object);
        return String.valueOf(this.getText(object)) + " - " + this.getQualifiedClassName(object);
    }

    protected String getQualifiedClassName(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            return EMFHelper.getQualifiedName((EClassifier)eClass, "::");
        }
        return "";
    }

    public String getQualifierText(Object element) {
        String result = null;
        EObject parent = this.getParentObject(element);
        if (parent != null) {
            result = this.getQualifiedText(parent);
        }
        return result;
    }

    private EObject getParentObject(Object element) {
        EObject eObject;
        EObject result = null;
        if (element != null && (eObject = EMFHelper.getEObject(element)) != null) {
            result = this.getParent(eObject);
        }
        return result;
    }

    public Image getQualifierImage(Object element) {
        Image result = null;
        EObject parent = this.getParentObject(element);
        if (parent != null) {
            result = this.getImage(parent);
        }
        return result;
    }

    protected EObject getParent(EObject object) {
        return object.eContainer();
    }

    protected String getQualifiedText(EObject object) {
        StringBuilder result = new StringBuilder();
        this.appendQualifiedText(object, result);
        return result.toString();
    }

    protected void appendQualifiedText(EObject object, StringBuilder buf) {
        String name;
        EObject parent = this.getParent(object);
        if (parent != null) {
            this.appendQualifiedText(parent, buf);
        }
        if (buf.length() > 0) {
            buf.append("::");
        }
        if ((name = this.getText(object)) == null) {
            name = String.format("<%s>", object.eClass().getName());
        }
        buf.append(name);
    }
}

