/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.resource.Replacement;
import org.eclipse.papyrus.infra.emf.resource.ReplacementImpl;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManagementHelper {
    public static Collection<Replacement> updateDependencies(URI uriToReplace, URI targetURI, Collection<Resource> fromResources, EditingDomain editingDomain) {
        if (fromResources == null || fromResources.isEmpty()) {
            throw new IllegalArgumentException("There is no resource to modify");
        }
        LinkedList<Replacement> replacements = new LinkedList<Replacement>();
        for (Resource currentResource : fromResources) {
            if (currentResource == null || EMFHelper.isReadOnly(currentResource, editingDomain)) continue;
            replacements.addAll(DependencyManagementHelper.updateDependencies(uriToReplace, targetURI, currentResource, editingDomain));
        }
        return replacements;
    }

    public static Collection<Replacement> updateDependencies(URI uriToReplace, URI targetURI, Resource fromResource, EditingDomain editingDomain) {
        if (uriToReplace == null) {
            throw new IllegalArgumentException("There is no URI to replace");
        }
        if (targetURI == null) {
            throw new IllegalArgumentException("There is no target URI");
        }
        if (uriToReplace.equals(targetURI)) {
            throw new IllegalArgumentException("The source and target URIs are identical");
        }
        if (fromResource == null) {
            throw new IllegalArgumentException("The edited resource must not be null");
        }
        TreeIterator allContentsIterator = fromResource.getAllContents();
        LinkedList<Replacement> replacements = new LinkedList<Replacement>();
        while (allContentsIterator.hasNext()) {
            EObject eObject = (EObject)allContentsIterator.next();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (reference.isContainer() || reference.isContainment() || reference.isDerived() || !reference.isChangeable()) continue;
                Object value = eObject.eGet((EStructuralFeature)reference, false);
                if (value instanceof EObject) {
                    EObject eObjectToReplace = (EObject)value;
                    EObject newEObject = DependencyManagementHelper.checkAndReplace(eObjectToReplace, uriToReplace, targetURI);
                    if (newEObject == null) continue;
                    try {
                        eObject.eSet((EStructuralFeature)reference, (Object)newEObject);
                        replacements.add(new ReplacementImpl(eObject, (EStructuralFeature)reference, eObjectToReplace, newEObject));
                    }
                    catch (Exception ex) {
                        Activator.log.error((Throwable)ex);
                    }
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                HashMap<EObject, EObject> previousToNewValue = new HashMap<EObject, EObject>();
                Collection collection = (Collection)value;
                for (Object collectionElement : (Collection)value) {
                    EObject eObjectToReplace;
                    EObject newEObject;
                    if (!(collectionElement instanceof EObject) || (newEObject = DependencyManagementHelper.checkAndReplace(eObjectToReplace = (EObject)collectionElement, uriToReplace, targetURI)) == null) continue;
                    previousToNewValue.put(eObjectToReplace, newEObject);
                }
                if (previousToNewValue.isEmpty() || !(collection instanceof EStructuralFeature.Setting)) continue;
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)collection;
                for (Map.Entry entry : previousToNewValue.entrySet()) {
                    EcoreUtil.replace((EStructuralFeature.Setting)setting, entry.getKey(), entry.getValue());
                    replacements.add(new ReplacementImpl(eObject, (EStructuralFeature)reference, (EObject)entry.getKey(), (EObject)entry.getValue()));
                }
            }
        }
        return replacements;
    }

    private static EObject checkAndReplace(EObject currentValueToReplace, URI uriToReplace, URI targetURI) {
        URI eObjectURIToReplace = EcoreUtil.getURI((EObject)currentValueToReplace);
        URI resourceURI = eObjectURIToReplace.trimFragment();
        if (!uriToReplace.equals(resourceURI)) {
            return null;
        }
        return DependencyManagementHelper.replace(currentValueToReplace, targetURI);
    }

    public static EObject replace(EObject currentValueToReplace, URI targetURI) {
        URI eObjectURIToReplace = EcoreUtil.getURI((EObject)currentValueToReplace);
        EClass targetEClass = currentValueToReplace.eClass();
        EObject newEObject = targetEClass.getEPackage().getEFactoryInstance().create(targetEClass);
        Object proxyEObject = newEObject instanceof InternalEObject ? (InternalEObject)newEObject : new DynamicEObjectImpl(targetEClass);
        String eObjectFragment = eObjectURIToReplace.fragment();
        URI eObjectURI = targetURI.appendFragment(eObjectFragment);
        proxyEObject.eSetProxyURI(eObjectURI);
        return proxyEObject;
    }

    public static Collection<Replacement> updateDependencies(URI uriToReplace, URI targetURI, ResourceSet resourceSet, EditingDomain editingDomain) {
        HashSet<Resource> resourcesToEdit = new HashSet<Resource>((Collection<Resource>)resourceSet.getResources());
        Resource resourceToReplace = resourceSet.getResource(uriToReplace, false);
        if (resourceToReplace != null) {
            resourcesToEdit.remove(resourceToReplace);
        }
        return DependencyManagementHelper.updateDependencies(uriToReplace, targetURI, resourcesToEdit, editingDomain);
    }

    public static Collection<Replacement> updateDependencies(URI uriToReplace, URI targetURI, Collection<Resource> fromResources) {
        return DependencyManagementHelper.updateDependencies(uriToReplace, targetURI, fromResources, null);
    }

    public static Collection<Replacement> updateDependencies(URI uriToReplace, URI targetURI, Resource fromResource) {
        return DependencyManagementHelper.updateDependencies(uriToReplace, targetURI, fromResource, null);
    }

    public static Collection<Replacement> updateDependencies(URI uriToReplace, URI targetURI, ResourceSet resourceSet) {
        HashSet<Resource> resourcesToEdit = new HashSet<Resource>((Collection<Resource>)resourceSet.getResources());
        resourcesToEdit.remove(resourceSet.getResource(uriToReplace, false));
        return DependencyManagementHelper.updateDependencies(uriToReplace, targetURI, resourcesToEdit, null);
    }

    public static void batchUpdateDependencies(Map<URI, URI> urisToReplace, Collection<Resource> resourcesToRepair, EditingDomain editingDomain) {
        for (Resource resource : resourcesToRepair) {
            if (EMFHelper.isReadOnly(resource, editingDomain)) continue;
            DependencyManagementHelper.batchUpdateDependencies(urisToReplace, resource, editingDomain);
        }
    }

    public static void batchUpdateDependencies(Map<URI, URI> urisToReplace, Resource fromResource, EditingDomain editingDomain) {
        TreeIterator allContentsIterator = fromResource.getAllContents();
        while (allContentsIterator.hasNext()) {
            EObject eObject = (EObject)allContentsIterator.next();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (reference.isContainer() || reference.isContainment() || reference.isDerived() || !reference.isChangeable()) continue;
                Object value = eObject.eGet((EStructuralFeature)reference, false);
                if (value instanceof EObject) {
                    EObject eObjectToReplace = (EObject)value;
                    EObject newEObject = DependencyManagementHelper.checkAndReplace(eObjectToReplace, urisToReplace);
                    if (newEObject == null) continue;
                    try {
                        eObject.eSet((EStructuralFeature)reference, (Object)newEObject);
                    }
                    catch (Exception ex) {
                        Activator.log.error((Throwable)ex);
                    }
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                HashMap<EObject, EObject> previousToNewValue = new HashMap<EObject, EObject>();
                Collection collection = (Collection)value;
                for (Object collectionElement : collection) {
                    EObject eObjectToReplace;
                    EObject newEObject;
                    if (!(collectionElement instanceof EObject) || (newEObject = DependencyManagementHelper.checkAndReplace(eObjectToReplace = (EObject)collectionElement, urisToReplace)) == null) continue;
                    previousToNewValue.put(eObjectToReplace, newEObject);
                }
                if (previousToNewValue.isEmpty() || !(collection instanceof EStructuralFeature.Setting)) continue;
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)collection;
                for (Map.Entry entry : previousToNewValue.entrySet()) {
                    EcoreUtil.replace((EStructuralFeature.Setting)setting, entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private static EObject checkAndReplace(EObject currentValueToReplace, Map<URI, URI> urisToReplace) {
        URI eObjectURIToReplace = EcoreUtil.getURI((EObject)currentValueToReplace);
        URI resourceURI = eObjectURIToReplace.trimFragment();
        URI targetURI = urisToReplace.get(resourceURI);
        if (targetURI == null) {
            return null;
        }
        return DependencyManagementHelper.replace(currentValueToReplace, targetURI);
    }
}

