/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.papyrus.infra.extendedtypes.ConfigurableElementMatcherFactoryRegistry;
import org.eclipse.papyrus.infra.extendedtypes.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.IConfigurableElementMatcher;
import org.eclipse.papyrus.infra.extendedtypes.ICreationElementValidator;
import org.eclipse.papyrus.infra.extendedtypes.IExtendedElementTypeFactory;
import org.eclipse.papyrus.infra.extendedtypes.IconEntry;
import org.eclipse.papyrus.infra.extendedtypes.MatcherConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.UnknowElementTypesException;
import org.eclipse.papyrus.infra.extendedtypes.types.ExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurableElementTypeFactory<T extends ElementTypeConfiguration>
implements IExtendedElementTypeFactory<T> {
    @Override
    public IExtendedHintedElementType createElementType(T configuration) throws UnknowElementTypesException {
        String id = configuration.getIdentifier();
        String displayName = configuration.getName();
        ArrayList<String> unknownTypes = null;
        ArrayList<IElementType> specializedTypes = new ArrayList<IElementType>(configuration.getSpecializedTypesID().size());
        for (String specializedTypeId : configuration.getSpecializedTypesID()) {
            IElementType specializedType = ElementTypeRegistry.getInstance().getType(specializedTypeId);
            if (specializedType == null) {
                if (unknownTypes == null) {
                    unknownTypes = new ArrayList<String>();
                }
                unknownTypes.add(specializedTypeId);
                continue;
            }
            specializedTypes.add(specializedType);
        }
        if (unknownTypes != null && unknownTypes.size() > 0) {
            throw new UnknowElementTypesException((List<String>)unknownTypes);
        }
        IElementType[] elementTypes = specializedTypes.toArray(new IElementType[0]);
        IconEntry entry = configuration.getIconEntry();
        URL iconURL = null;
        if (entry != null) {
            iconURL = this.getURLFromEntry(entry);
        }
        ExtendedHintedElementType type = new ExtendedHintedElementType(id, iconURL, displayName, elementTypes, this.createElementMatcher(configuration), this.createContainerDescriptor(configuration), this.createEditHelperAdvice(configuration), this.getSemanticHint(configuration), this.createElementCreationValidator(configuration));
        return type;
    }

    protected String getSemanticHint(T configuration) {
        return configuration.getHint();
    }

    protected abstract IEditHelperAdvice createEditHelperAdvice(T var1);

    protected abstract IContainerDescriptor createContainerDescriptor(T var1);

    protected IElementMatcher createElementMatcher(T configuration) {
        MatcherConfiguration matcherConfiguration = configuration.getMatcherConfiguration();
        if (matcherConfiguration == null) {
            return null;
        }
        IConfigurableElementMatcher<MatcherConfiguration> matcher = ConfigurableElementMatcherFactoryRegistry.getInstance().createElementMatcher(matcherConfiguration);
        return matcher;
    }

    @Override
    public abstract ICreationElementValidator createElementCreationValidator(T var1);

    protected URL getURLFromEntry(IconEntry entry) {
        Bundle bundle = Platform.getBundle((String)entry.getBundleId());
        if (bundle == null) {
            return null;
        }
        URL result = bundle.getEntry(entry.getIconPath());
        if (result == null) {
            try {
                result = new URL(entry.getIconPath());
            }
            catch (MalformedURLException e) {
                result = null;
            }
        }
        return result;
    }
}

