/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.infra.extendedtypes.ComposedElementMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedContainerDescriptor
implements IContainerDescriptor {
    private final List<IContainerDescriptor> containerDescriptors;

    public ComposedContainerDescriptor(List<IContainerDescriptor> containerDescriptors) {
        this.containerDescriptors = containerDescriptors;
    }

    public IElementMatcher getMatcher() {
        ArrayList<IElementMatcher> matchers = new ArrayList<IElementMatcher>();
        for (IContainerDescriptor containerDescriptor : this.getContainerDescriptors()) {
            IElementMatcher composedMatcher = containerDescriptor.getMatcher();
            if (composedMatcher == null) continue;
            matchers.add(composedMatcher);
        }
        if (matchers != null && !matchers.isEmpty()) {
            return new ComposedElementMatcher(matchers);
        }
        return null;
    }

    public EReference[] getContainmentFeatures() {
        List<EReference> joinReferences = null;
        for (IContainerDescriptor containerDescriptor : this.getContainerDescriptors()) {
            EReference[] eReferencesArray = containerDescriptor.getContainmentFeatures();
            if (eReferencesArray == null) continue;
            List<EReference> eReferences = Arrays.asList(eReferencesArray);
            if (joinReferences == null) {
                joinReferences = eReferences;
                continue;
            }
            ArrayList<EReference> newReferences = new ArrayList<EReference>();
            for (EReference eReference : joinReferences) {
                if (!eReferences.contains(eReference)) continue;
                newReferences.add(eReference);
            }
            joinReferences = newReferences;
        }
        if (joinReferences != null) {
            return joinReferences.toArray(new EReference[0]);
        }
        return null;
    }

    protected List<IContainerDescriptor> getContainerDescriptors() {
        return this.containerDescriptors;
    }
}

