/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.SpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.SpecializationTypeRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.ExtendedElementTypeSet;
import org.eclipse.papyrus.infra.extendedtypes.IExtendedElementTypeFactory;
import org.eclipse.papyrus.infra.extendedtypes.UnknowElementTypesException;
import org.eclipse.papyrus.infra.extendedtypes.preferences.ExtendedTypesPreferences;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedElementTypeSetRegistry {
    public static final String LOCAL_CONTRIBUTOR_ID = "local contribution";
    private static ExtendedElementTypeSetRegistry registry;
    protected Map<String, ExtendedElementTypeSet> extendedTypeSets = null;
    protected ResourceSet extendedTypesResourceSet = null;
    protected List<ExtendedElementTypeSet> loadedExtendedElementTypeSets = null;
    protected Map<String, IExtendedElementTypeFactory<ElementTypeConfiguration>> configurationTypeToElementTypeFactory = null;
    protected List<String> configurationTypeFactoryExceptions = null;
    private static Map<String, WeakReference<Class<?>>> successLookupTable;
    private static Set<String> failureLookupTable;
    private static Map<Bundle, Set<String>> bundleToExceptionsSetMap;

    static {
        successLookupTable = new HashMap();
        failureLookupTable = new HashSet<String>();
        bundleToExceptionsSetMap = new HashMap<Bundle, Set<String>>();
    }

    public static synchronized ExtendedElementTypeSetRegistry getInstance() {
        if (registry == null) {
            registry = new ExtendedElementTypeSetRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        this.extendedTypesResourceSet = null;
        this.extendedTypeSets = null;
        this.configurationTypeToElementTypeFactory = new HashMap<String, IExtendedElementTypeFactory<ElementTypeConfiguration>>();
        this.extendedTypesResourceSet = this.createResourceSet();
        this.extendedTypeSets = this.loadExtendedTypeSets();
    }

    public void dispose() {
        if (this.extendedTypeSets == null) {
            return;
        }
        ArrayList<Map.Entry<String, ExtendedElementTypeSet>> entriesToDispose = new ArrayList<Map.Entry<String, ExtendedElementTypeSet>>(this.extendedTypeSets.entrySet());
        for (Map.Entry entry : entriesToDispose) {
            this.unload((String)entry.getKey());
        }
        this.extendedTypesResourceSet = null;
        this.extendedTypeSets = null;
        this.configurationTypeToElementTypeFactory = new HashMap<String, IExtendedElementTypeFactory<ElementTypeConfiguration>>();
        this.extendedTypesResourceSet = null;
        registry = null;
    }

    public Map<String, List<String>> loadExtendedElementTypeSetWithDelay(String identifier, List<String> loadedElementTypes) {
        if (this.getExtendedTypeSets() == null) {
            return Collections.emptyMap();
        }
        String path = ExtendedTypesPreferences.getLocalExtendedTypesDefinitions().get(identifier);
        if (path == null) {
            return Collections.emptyMap();
        }
        URI localURI = URI.createPlatformResourceURI((String)path, (boolean)true);
        Resource resource = this.extendedTypesResourceSet.createResource(localURI);
        try {
            resource.load(null);
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof ExtendedElementTypeSet) {
                this.getExtendedTypeSets().put(identifier, (ExtendedElementTypeSet)content);
                return this.loadExtendedElementTypeSetWithDelay((ExtendedElementTypeSet)content, null, loadedElementTypes);
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return Collections.emptyMap();
    }

    public Map<String, List<String>> loadExtendedElementTypeSetWithDelay(ExtendedElementTypeSet extendedElementTypeSet, Map<ExtendedElementTypeSet, List<String>> missingTypesBySets, List<String> loadedElementTypes) {
        IClientContext context;
        HashMap<String, EList<String>> unresolvedElementTypes = null;
        try {
            context = TypeContext.getContext();
        }
        catch (ServiceException e1) {
            Activator.log.error((Throwable)e1);
            return Collections.emptyMap();
        }
        ArrayList<ElementTypeConfiguration> elementTypeConfigurations = new ArrayList<ElementTypeConfiguration>((Collection<ElementTypeConfiguration>)extendedElementTypeSet.getElementType());
        if (missingTypesBySets != null && missingTypesBySets.containsKey(extendedElementTypeSet)) {
            List<String> notLoadedTypes = missingTypesBySets.get(extendedElementTypeSet);
            for (ElementTypeConfiguration configuration : extendedElementTypeSet.getElementType()) {
                if (notLoadedTypes.contains(configuration.getIdentifier())) continue;
                elementTypeConfigurations.remove(configuration);
            }
        }
        for (ElementTypeConfiguration configuration : elementTypeConfigurations) {
            Class<IExtendedElementTypeFactory<ElementTypeConfiguration>> factoryClass;
            String configurationType = configuration.eClass().getInstanceTypeName();
            IExtendedElementTypeFactory<ElementTypeConfiguration> factory = this.configurationTypeToElementTypeFactory.get(configurationType);
            if (factory == null && this.isNotInFactoryExceptionList(configurationType) && (factoryClass = this.retrieveFactoryClassFromExtensionPoint(configurationType)) != null) {
                try {
                    factory = factoryClass.newInstance();
                }
                catch (InstantiationException e) {
                    if (this.configurationTypeFactoryExceptions == null) {
                        this.configurationTypeFactoryExceptions = new ArrayList<String>();
                    }
                    this.configurationTypeFactoryExceptions.add(configurationType);
                }
                catch (IllegalAccessException e) {
                    if (this.configurationTypeFactoryExceptions == null) {
                        this.configurationTypeFactoryExceptions = new ArrayList<String>();
                    }
                    this.configurationTypeFactoryExceptions.add(configurationType);
                }
                this.configurationTypeToElementTypeFactory.put(configurationType, factory);
            }
            if (factory == null) continue;
            try {
                IExtendedHintedElementType type = factory.createElementType(configuration);
                ElementTypeRegistry.getInstance().register((ISpecializationType)type);
                context.bindId(type.getId());
                loadedElementTypes.add(type.getId());
            }
            catch (UnknowElementTypesException e) {
                if (unresolvedElementTypes == null) {
                    unresolvedElementTypes = new HashMap<String, EList<String>>();
                }
                unresolvedElementTypes.put(configuration.getIdentifier(), configuration.getSpecializedTypesID());
            }
        }
        return unresolvedElementTypes;
    }

    public void unload(String identifier) {
        if (this.extendedTypeSets == null) {
            return;
        }
        ExtendedElementTypeSet elementTypeSet = this.extendedTypeSets.get(identifier);
        if (elementTypeSet == null) {
            this.extendedTypeSets.remove(identifier);
            return;
        }
        Field declaredField = null;
        try {
            declaredField = ElementTypeRegistry.class.getDeclaredField("specializationTypeRegistry");
        }
        catch (SecurityException e1) {
            Activator.log.error((Throwable)e1);
            return;
        }
        catch (NoSuchFieldException e1) {
            Activator.log.error((Throwable)e1);
            return;
        }
        if (declaredField == null) {
            Activator.log.error("impossible to find specializationTypeRegistry", null);
            return;
        }
        declaredField.setAccessible(true);
        SpecializationTypeRegistry registry = null;
        try {
            registry = (SpecializationTypeRegistry)declaredField.get(ElementTypeRegistry.getInstance());
        }
        catch (IllegalArgumentException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        if (registry == null) {
            return;
        }
        for (ElementTypeConfiguration configuration : elementTypeSet.getElementType()) {
            String configIdentifier;
            SpecializationTypeDescriptor descriptor;
            if (configuration == null || configuration.getIdentifier() == null || (descriptor = registry.getSpecializationTypeDescriptor(configIdentifier = configuration.getIdentifier())) == null) continue;
            IEditHelperAdviceDescriptor adviceDescriptor = descriptor.getEditHelperAdviceDescriptor();
            String targetId = adviceDescriptor.getTypeId();
            this.removeAdviceFromBindings(registry, targetId, adviceDescriptor);
            registry.removeSpecializationType(descriptor);
        }
        if (elementTypeSet.eResource() != null) {
            elementTypeSet.eResource().unload();
            if (this.extendedTypesResourceSet != null) {
                this.extendedTypesResourceSet.getResources().remove((Object)elementTypeSet.eResource());
            }
        }
        this.extendedTypeSets.remove(identifier);
    }

    protected void removeAdviceFromBindings(SpecializationTypeRegistry registry, String adviceDescriptorId, IEditHelperAdviceDescriptor adviceDescriptor) {
        Set bindings;
        Map adviceBindings = null;
        Field adviceBindingsField = null;
        try {
            adviceBindingsField = SpecializationTypeRegistry.class.getDeclaredField("adviceBindings");
        }
        catch (SecurityException e1) {
            Activator.log.error((Throwable)e1);
            return;
        }
        catch (NoSuchFieldException e1) {
            Activator.log.error((Throwable)e1);
            return;
        }
        if (adviceBindingsField == null) {
            Activator.log.error("impossible to find adviceBindings", null);
            return;
        }
        adviceBindingsField.setAccessible(true);
        try {
            adviceBindings = (Map)adviceBindingsField.get(registry);
        }
        catch (IllegalArgumentException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        if (adviceBindings != null && (bindings = (Set)adviceBindings.get(adviceDescriptorId)) != null) {
            bindings.remove(adviceDescriptor);
        }
    }

    protected boolean isNotInFactoryExceptionList(String configurationType) {
        if (this.configurationTypeFactoryExceptions == null) {
            return true;
        }
        return !this.configurationTypeFactoryExceptions.contains(configurationType);
    }

    protected Class<IExtendedElementTypeFactory<ElementTypeConfiguration>> retrieveFactoryClassFromExtensionPoint(String configurationType) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.extendedtypes.extendedTypeConfiguration");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String eCoreClassName = configurationElement.getAttribute("configurationClass");
            if (configurationType.equals(eCoreClassName)) {
                String factoryClassName = configurationElement.getAttribute("factoryClass");
                return ExtendedElementTypeSetRegistry.loadClass(factoryClassName, configurationElement.getContributor().getName());
            }
            ++n2;
        }
        return null;
    }

    protected Map<String, ExtendedElementTypeSet> loadExtendedTypeSets() {
        Map<String, ExtendedElementTypeSet> registeredSets;
        HashMap<String, ExtendedElementTypeSet> extendedElementTypeSets = new HashMap<String, ExtendedElementTypeSet>();
        Map<String, ExtendedElementTypeSet> localSets = this.loadExtendedTypeSetsFromWorkspace();
        if (localSets != null && !localSets.isEmpty()) {
            extendedElementTypeSets.putAll(localSets);
        }
        if ((registeredSets = this.loadExtendedTypeSetsFromPlatform(localSets.keySet())) != null && !registeredSets.isEmpty()) {
            extendedElementTypeSets.putAll(registeredSets);
        }
        ArrayList setsToLoad = new ArrayList(extendedElementTypeSets.values());
        HashMap<ExtendedElementTypeSet, List<String>> missingTypesBySets = new HashMap<ExtendedElementTypeSet, List<String>>();
        ArrayList<String> loadedElements = null;
        while (loadedElements == null || !loadedElements.isEmpty()) {
            loadedElements = new ArrayList<String>();
            for (ExtendedElementTypeSet set : new ArrayList(setsToLoad)) {
                Map<String, List<String>> notLoadedTypes = this.loadExtendedElementTypeSetWithDelay(set, missingTypesBySets, loadedElements);
                if (notLoadedTypes == null || notLoadedTypes.isEmpty()) {
                    setsToLoad.remove(set);
                    missingTypesBySets.remove(set);
                    continue;
                }
                missingTypesBySets.put(set, new ArrayList<String>(notLoadedTypes.keySet()));
            }
        }
        if (missingTypesBySets.entrySet() != null && missingTypesBySets.entrySet().size() > 0 && Platform.inDebugMode()) {
            System.err.println(missingTypesBySets);
        }
        return extendedElementTypeSets;
    }

    protected Map<String, ExtendedElementTypeSet> loadExtendedTypeSetsFromWorkspace() {
        Map<String, String> localFilesPath = ExtendedTypesPreferences.getLocalExtendedTypesDefinitions();
        HashMap<String, ExtendedElementTypeSet> workspaceElementTypeSets = new HashMap<String, ExtendedElementTypeSet>();
        if (localFilesPath != null && !localFilesPath.isEmpty()) {
            for (Map.Entry<String, String> idToPath : localFilesPath.entrySet()) {
                String filePath = idToPath.getValue();
                String id = idToPath.getKey();
                URI localURI = URI.createPlatformResourceURI((String)filePath, (boolean)true);
                Resource resource = this.extendedTypesResourceSet.createResource(localURI);
                try {
                    resource.load(null);
                    EObject content = (EObject)resource.getContents().get(0);
                    if (!(content instanceof ExtendedElementTypeSet)) continue;
                    workspaceElementTypeSets.put(id, (ExtendedElementTypeSet)content);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return workspaceElementTypeSets;
    }

    protected Map<String, ExtendedElementTypeSet> loadExtendedTypeSetsFromPlatform(Set<String> workspaceDefinitions) {
        IConfigurationElement[] elements;
        HashMap<String, ExtendedElementTypeSet> platformElementTypeSets = new HashMap<String, ExtendedElementTypeSet>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.extendedtypes.extendedElementTypeSet");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ExtendedElementTypeSet set;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String modelPath = element.getAttribute("path");
            String extendedTypeSetId = element.getAttribute("id");
            String contributorID = element.getContributor().getName();
            if (Platform.inDebugMode()) {
                Activator.log.debug("[Reading extension point]");
                Activator.log.debug("-  Path to the model: " + modelPath);
                Activator.log.debug("-  id of the container bundle: " + contributorID);
                Activator.log.debug("-  id of the extended type set: " + extendedTypeSetId);
            }
            if ((set = this.getExtendedElementTypeSet(extendedTypeSetId, modelPath, contributorID)) != null && !workspaceDefinitions.contains(extendedTypeSetId)) {
                platformElementTypeSets.put(extendedTypeSetId, set);
            }
            ++n2;
        }
        return platformElementTypeSets;
    }

    protected ExtendedElementTypeSet getExtendedElementTypeSet(String extendedTypesID, String modelPath, String bundleId) {
        Bundle bundle;
        String filePath = ExtendedTypesPreferences.getExtendedTypesRedefinition(extendedTypesID);
        if (filePath != null) {
            this.getExtendedElementTypeSetInPluginStateArea(extendedTypesID);
        }
        if (Platform.isFragment((Bundle)(bundle = Platform.getBundle((String)bundleId)))) {
            return this.getExtendedElementTypeSetInBundle(modelPath, bundleId);
        }
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments == null) {
            return this.getExtendedElementTypeSetInBundle(modelPath, bundleId);
        }
        Bundle[] bundleArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            ExtendedElementTypeSet extendedElementTypeSet = this.getExtendedElementTypeSetInBundle(modelPath, fragment.getSymbolicName());
            if (extendedElementTypeSet != null) {
                return extendedElementTypeSet;
            }
            ++n2;
        }
        return this.getExtendedElementTypeSetInBundle(modelPath, bundleId);
    }

    protected ExtendedElementTypeSet getExtendedElementTypeSetInPluginStateArea(String path) {
        IPath resourcePath = Activator.getDefault().getStateLocation().append(path);
        URI uri = URI.createFileURI((String)resourcePath.toOSString());
        if (uri != null && uri.isFile()) {
            Resource resource = this.extendedTypesResourceSet.createResource(uri);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                return null;
            }
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof ExtendedElementTypeSet) {
                return (ExtendedElementTypeSet)content;
            }
            Activator.log.error("Impossible to cast the object into an ExtendedElementTypeSet: " + content, null);
            return null;
        }
        return null;
    }

    protected ExtendedElementTypeSet getExtendedElementTypeSetInBundle(String modelPath, String bundleID) {
        Resource resource = this.extendedTypesResourceSet.createResource(URI.createPlatformPluginURI((String)(String.valueOf(bundleID) + '/' + modelPath), (boolean)true));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            return null;
        }
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ExtendedElementTypeSet) {
            return (ExtendedElementTypeSet)content;
        }
        Activator.log.error("Impossible to cast the object into an ExtendedElementTypeSet: " + content, null);
        return null;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        return set;
    }

    protected static Class<?> loadClass(String className, String pluginId) {
        Class found;
        StringBuffer keyStringBuf = new StringBuffer(className.length() + pluginId.length() + 2);
        keyStringBuf.append(pluginId);
        keyStringBuf.append('.');
        keyStringBuf.append(className);
        String keyString = keyStringBuf.toString();
        WeakReference<Class<?>> ref = successLookupTable.get(keyString);
        Class clazz = found = ref != null ? (Class)ref.get() : null;
        if (found == null) {
            if (ref != null) {
                successLookupTable.remove(keyString);
            }
            if (!failureLookupTable.contains(keyString)) {
                try {
                    Bundle bundle = ExtendedElementTypeSetRegistry.basicGetPluginBundle(pluginId);
                    if (bundle != null) {
                        int state = bundle.getState();
                        if (state == 32 || ExtendedElementTypeSetRegistry.isInExceptionList(bundle, className)) {
                            found = bundle.loadClass(className);
                            successLookupTable.put(keyString, new WeakReference<Class>(found));
                            if (state == 32) {
                                bundleToExceptionsSetMap.remove(bundle);
                            }
                        }
                    } else {
                        failureLookupTable.add(keyString);
                    }
                }
                catch (ClassNotFoundException e) {
                    failureLookupTable.add(keyString);
                }
            }
        }
        return found;
    }

    protected static Bundle getPluginBundle(String pluginId) {
        Bundle bundle = ExtendedElementTypeSetRegistry.basicGetPluginBundle(pluginId);
        if (bundle != null && bundle.getState() == 32) {
            return bundle;
        }
        return null;
    }

    private static Bundle basicGetPluginBundle(String pluginId) {
        return Platform.getBundle((String)pluginId);
    }

    private static boolean isInExceptionList(Bundle bundle, String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        Set<String> exceptionSet = bundleToExceptionsSetMap.get(bundle);
        if (exceptionSet == null) {
            Dictionary dict = bundle.getHeaders();
            String value = (String)dict.get("Eclipse-LazyStart");
            if (value != null) {
                int index = value.indexOf("exceptions");
                if (index != -1) {
                    try {
                        int start = value.indexOf(34, index + 1);
                        int end = value.indexOf(34, start + 1);
                        String exceptions = value.substring(start + 1, end);
                        exceptionSet = new HashSet<String>(2);
                        StringTokenizer tokenizer = new StringTokenizer(exceptions, ",");
                        while (tokenizer.hasMoreTokens()) {
                            exceptionSet.add(tokenizer.nextToken().trim());
                        }
                    }
                    catch (IndexOutOfBoundsException exception) {
                        exceptionSet = Collections.emptySet();
                    }
                } else {
                    exceptionSet = Collections.emptySet();
                }
            } else {
                exceptionSet = Collections.emptySet();
            }
            bundleToExceptionsSetMap.put(bundle, exceptionSet);
        }
        return exceptionSet.contains(packageName);
    }

    public Map<String, ExtendedElementTypeSet> getExtendedTypeSets() {
        return this.extendedTypeSets;
    }
}

