/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerUtils;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantEditHelperAdvice;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInvariantEditHelperAdvice<InvariantContainerConfiguration> {
    protected List<HierarchyPermission> permissions;
    protected IClientContext sharedContext;

    public boolean approveRequest(IEditCommandRequest request) {
        EReference reference;
        SetRequest setRequest;
        EStructuralFeature structuralFeature;
        if (request instanceof SetRequest && (structuralFeature = (setRequest = (SetRequest)request).getFeature()) instanceof EReference && (reference = (EReference)structuralFeature).isContainment() && setRequest.getValue() != null) {
            return this.canContain(setRequest);
        }
        return super.approveRequest(request);
    }

    protected boolean canContain(SetRequest request) {
        IElementType[] containerTypes = ElementTypeRegistry.getInstance().getAllTypesMatching(request.getElementToEdit(), request.getClientContext());
        return InvariantContainerUtils.isContainerValid(containerTypes, false, this.permissions);
    }

    @Override
    public void init(InvariantContainerConfiguration configuration) {
        try {
            this.sharedContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        this.permissions = configuration.getPermissions();
    }
}

