/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerUtils {
    public static boolean isContainerValid(IElementType[] containerTypes, boolean baseIsValid, List<HierarchyPermission> permissions) {
        boolean isValid = baseIsValid;
        for (HierarchyPermission permission : permissions) {
            boolean isPermitted = permission.isIsPermitted();
            String childType = permission.getChildType();
            boolean isStrict = permission.isIsStrict();
            IElementType type = ElementTypeRegistry.getInstance().getType(childType);
            if (type == null) continue;
            if (isStrict) {
                isValid = containerTypes[0].equals(type) ? isPermitted : !isPermitted;
                continue;
            }
            ArrayList<IElementType> allTypes = new ArrayList<IElementType>(Arrays.asList(containerTypes));
            boolean bl = allTypes.contains(type) ? isPermitted : (isValid = !isPermitted);
        }
        return isValid;
    }
}

