/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;

public class CheckedOperationHistory
implements IOperationHistory {
    protected static final IOperationApprover2[] approversArray;
    protected IOperationHistory history = OperationHistoryFactory.getOperationHistory();

    static {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.gmfdiag.commands", "operationApprover");
        LinkedList<ApproverPriorityPair> approverPriorityPairs = new LinkedList<ApproverPriorityPair>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("operationApprover".equals(elem.getName())) {
                try {
                    ApproverPriorityPair approverPriorityPair = new ApproverPriorityPair();
                    approverPriorityPair.approver = (IOperationApprover2)elem.createExecutableExtension("class");
                    approverPriorityPair.priority = Integer.parseInt(elem.getAttribute("priority"));
                    approverPriorityPairs.add(approverPriorityPair);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in instantiation of operation approver.", (Throwable)e);
                }
            }
            ++n2;
        }
        Collections.sort(approverPriorityPairs);
        approversArray = new IOperationApprover2[approverPriorityPairs.size()];
        int i = 0;
        while (i < approversArray.length) {
            CheckedOperationHistory.approversArray[i] = ((ApproverPriorityPair)approverPriorityPairs.get((int)i)).approver;
            ++i;
        }
    }

    public static CheckedOperationHistory getInstance() {
        return CheckedOperationHistoryHolder.instance;
    }

    private CheckedOperationHistory() {
        CheckedOperationHistory.addRegisteredListeners(this.history);
    }

    protected IStatus getRedoApproval(IUndoableOperation operation, IAdaptable info) {
        operation = this.unwrap(operation);
        int i = 0;
        while (i < approversArray.length) {
            IStatus approval = approversArray[i].proceedRedoing(operation, (IOperationHistory)this, info);
            if (!approval.isOK()) {
                return approval;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getUndoApproval(IUndoableOperation operation, IAdaptable info) {
        operation = this.unwrap(operation);
        int i = 0;
        while (i < approversArray.length) {
            IStatus approval = approversArray[i].proceedUndoing(operation, (IOperationHistory)this, info);
            if (!approval.isOK()) {
                return approval;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getExecuteApproval(IUndoableOperation operation, IAdaptable info) {
        operation = this.unwrap(operation);
        int i = 0;
        while (i < approversArray.length) {
            IStatus approval = approversArray[i].proceedExecuting(operation, (IOperationHistory)this, info);
            if (!approval.isOK()) {
                return approval;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    protected IUndoableOperation unwrap(IUndoableOperation operation) {
        ICommand gmfCommand;
        Command emfCommand;
        if (operation instanceof EMFCommandOperation && (emfCommand = ((EMFCommandOperation)operation).getCommand()) instanceof GMFtoEMFCommandWrapper && (gmfCommand = ((GMFtoEMFCommandWrapper)emfCommand).getGMFCommand()) != null) {
            return gmfCommand;
        }
        return operation;
    }

    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.getExecuteApproval(operation, info);
        if (!status.isOK()) {
            return status;
        }
        return this.history.execute(operation, monitor, info);
    }

    public IStatus undo(IUndoContext context, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)context);
        IUndoableOperation operation = this.getUndoOperation(context);
        if (operation == null) {
            return IOperationHistory.NOTHING_TO_UNDO_STATUS;
        }
        IStatus status = this.getUndoApproval(operation, info);
        if (!status.isOK()) {
            return status;
        }
        return this.history.undo(context, monitor, info);
    }

    public IStatus redo(IUndoContext context, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)context);
        IUndoableOperation operation = this.getRedoOperation(context);
        if (operation == null) {
            return IOperationHistory.NOTHING_TO_REDO_STATUS;
        }
        IStatus status = this.getRedoApproval(operation, info);
        if (!status.isOK()) {
            return status;
        }
        return this.history.redo(context, monitor, info);
    }

    private static void addRegisteredListeners(IOperationHistory history) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.gmfdiag.commands", "historyListeners");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("historyListener".equals(elem.getName())) {
                try {
                    IOperationHistoryListener listener = (IOperationHistoryListener)elem.createExecutableExtension("class");
                    history.addOperationHistoryListener(listener);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in instantiation of operation history listener.", (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public IStatus undoOperation(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.history.undoOperation(operation, monitor, info);
    }

    public void setLimit(IUndoContext context, int limit) {
        this.history.setLimit(context, limit);
    }

    public void replaceOperation(IUndoableOperation operation, IUndoableOperation[] replacements) {
        this.history.replaceOperation(operation, replacements);
    }

    public void removeOperationHistoryListener(IOperationHistoryListener listener) {
        this.history.removeOperationHistoryListener(listener);
    }

    public void removeOperationApprover(IOperationApprover approver) {
        this.history.removeOperationApprover(approver);
    }

    public IStatus redoOperation(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.history.redoOperation(operation, monitor, info);
    }

    public void operationChanged(IUndoableOperation operation) {
        this.history.operationChanged(operation);
    }

    public void openOperation(ICompositeOperation operation, int mode) {
        this.history.openOperation(operation, mode);
    }

    public IUndoableOperation getUndoOperation(IUndoContext context) {
        return this.history.getUndoOperation(context);
    }

    public IUndoableOperation[] getUndoHistory(IUndoContext context) {
        return this.history.getUndoHistory(context);
    }

    public IUndoableOperation getRedoOperation(IUndoContext context) {
        return this.history.getRedoOperation(context);
    }

    public IUndoableOperation[] getRedoHistory(IUndoContext context) {
        return this.history.getRedoHistory(context);
    }

    public int getLimit(IUndoContext context) {
        return this.history.getLimit(context);
    }

    public void dispose(IUndoContext context, boolean flushUndo, boolean flushRedo, boolean flushContext) {
        this.history.dispose(context, flushUndo, flushRedo, flushContext);
    }

    public void closeOperation(boolean operationOK, boolean addToHistory, int mode) {
        this.history.closeOperation(operationOK, addToHistory, mode);
    }

    public boolean canUndo(IUndoContext context) {
        return this.history.canUndo(context);
    }

    public boolean canRedo(IUndoContext context) {
        return this.history.canRedo(context);
    }

    public void addOperationHistoryListener(IOperationHistoryListener listener) {
        this.history.addOperationHistoryListener(listener);
    }

    public void addOperationApprover(IOperationApprover approver) {
        this.history.addOperationApprover(approver);
    }

    public void add(IUndoableOperation operation) {
        this.history.add(operation);
    }

    /* synthetic */ CheckedOperationHistory(CheckedOperationHistory checkedOperationHistory) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApproverPriorityPair
    implements Comparable<ApproverPriorityPair> {
        public IOperationApprover2 approver;
        public int priority;

        private ApproverPriorityPair() {
        }

        @Override
        public int compareTo(ApproverPriorityPair o) {
            if (o.priority > this.priority) {
                return 1;
            }
            if (o.priority < this.priority) {
                return -1;
            }
            return 0;
        }
    }

    private static class CheckedOperationHistoryHolder {
        public static final CheckedOperationHistory instance = new CheckedOperationHistory(null);

        private CheckedOperationHistoryHolder() {
        }
    }
}

