/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.FixEdgeAnchorsDeferredCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.FixAnchorHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

public class XYLayoutWithConstrainedResizedEditPolicy
extends XYLayoutEditPolicy {
    private FixAnchorHelper helper = null;

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        if (child instanceof ConnectionEditPart && child.getParent() instanceof DiagramRootEditPart) {
            return null;
        }
        return super.getCurrentConstraintFor(child);
    }

    protected Command getCreateCommand(CreateRequest request) {
        boolean couldBeSnaped;
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        Iterator iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        boolean bl = couldBeSnaped = request.getLocation().equals((Object)LayoutHelper.UNDEFINED.getLocation()) && req.isSnapToEnabled();
        if (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            if (couldBeSnaped) {
                int add = 0;
                DiagramRootEditPart drep = (DiagramRootEditPart)this.getHost().getRoot();
                double spacing = drep.getGridSpacing();
                double max_value = spacing * 20.0;
                SnapToHelper helper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
                if (helper != null) {
                    LayoutHelper layoutHelper = new LayoutHelper();
                    while ((double)add < max_value) {
                        Rectangle LOCAL_BOUNDS = BOUNDS.getCopy();
                        LOCAL_BOUNDS.translate(add, add);
                        Rectangle tmp_rect = this.getBoundsOffest(req, LOCAL_BOUNDS, viewDescriptor);
                        PrecisionRectangle resultRect = new PrecisionRectangle(tmp_rect);
                        resultRect.setWidth(-1);
                        resultRect.setHeight(-1);
                        PrecisionPoint res1 = new PrecisionPoint(tmp_rect.getLocation());
                        helper.snapPoint((Request)request, 9, res1.getPreciseCopy(), res1);
                        Point pt = layoutHelper.validatePosition(this.getHostFigure(), resultRect.setLocation((Point)res1));
                        if (!couldBeSnaped) continue;
                        if (pt.equals((Object)resultRect.getLocation())) {
                            rect.setLocation(resultRect.getLocation());
                            break;
                        }
                        add = (int)((double)add + spacing);
                    }
                }
            }
            cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect));
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce()));
    }

    protected Command getChangeConstraintCommand(ChangeBoundsRequest request) {
        boolean isConstrainedResize;
        CompoundCommand resize = new CompoundCommand("Resize Command");
        List children = request.getEditParts();
        int direction = request.getResizeDirection();
        boolean forceLocation = isConstrainedResize = request.isConstrainedResize();
        int i = 0;
        while (i < children.size()) {
            IGraphicalEditPart child = (IGraphicalEditPart)children.get(i);
            resize.add(this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child))));
            Point move = request.getMoveDelta();
            if (forceLocation) {
                for (Object object : child.getChildren()) {
                    EditPolicy layoutPolicy;
                    if (!(object instanceof CompartmentEditPart) || !((layoutPolicy = ((CompartmentEditPart)object).getEditPolicy((Object)"LayoutEditPolicy")) instanceof org.eclipse.gef.editpolicies.XYLayoutEditPolicy)) continue;
                    for (Object current : ((CompartmentEditPart)object).getChildren()) {
                        if (!(current instanceof NodeEditPart)) continue;
                        ChangeBoundsRequest forceLocationRequest = new ChangeBoundsRequest();
                        forceLocationRequest.setType((Object)"move");
                        forceLocationRequest.setMoveDelta(move.getNegated());
                        forceLocationRequest.setEditParts((EditPart)current);
                        Command tmp = ((NodeEditPart)current).getCommand((Request)forceLocationRequest);
                        if (tmp == null) continue;
                        resize.add(tmp);
                    }
                }
            }
            if (isConstrainedResize && child instanceof INodeEditPart) {
                Command fixAnchorCommand;
                if (this.helper == null) {
                    TransactionalEditingDomain domain = null;
                    try {
                        domain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain(child);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                    this.helper = new FixAnchorHelper(domain);
                }
                if ((fixAnchorCommand = this.helper.getFixIdentityAnchorCommand((INodeEditPart)child, request.getMoveDelta(), request.getSizeDelta(), request.getResizeDirection())) != null) {
                    resize.add(fixAnchorCommand);
                }
            }
            ++i;
        }
        return resize.unwrap();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Command cmd = super.createChangeConstraintCommand(request, child, constraint);
        if ("move children".equals(request.getType()) && child instanceof INodeEditPart) {
            List sources = ((INodeEditPart)child).getSourceConnections();
            List targets = ((INodeEditPart)child).getTargetConnections();
            HashSet connections = new HashSet();
            connections.addAll(sources);
            connections.addAll(targets);
            if (!connections.isEmpty()) {
                CompoundCommand cc = new CompoundCommand();
                cc.add(cmd);
                cc.add((Command)new ICommandProxy((ICommand)new FixEdgeAnchorsDeferredCommand(this.getEditingDomain(), (IGraphicalEditPart)this.getHost(), connections)));
                return cc;
            }
        }
        return cmd;
    }

    protected final TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain domain = null;
        try {
            domain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain(this.getHost());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return domain;
    }
}

