/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;

public class CSSDOMSemanticElementHelper {
    public static EObject findSemanticElement(EObject notationElement) {
        if (notationElement == null) {
            return null;
        }
        if (notationElement instanceof Diagram) {
            return notationElement;
        }
        if (notationElement instanceof BasicCompartment) {
            return notationElement;
        }
        if (CSSDOMSemanticElementHelper.isFloatingLabel(notationElement)) {
            return notationElement;
        }
        if (notationElement instanceof View) {
            View view = (View)notationElement;
            EObject semanticElement = view.getElement();
            if (semanticElement != null) {
                return semanticElement;
            }
            return view;
        }
        EObject currentElement = notationElement.eContainer();
        while (currentElement != null) {
            if (currentElement instanceof View) {
                return CSSDOMSemanticElementHelper.findSemanticElement(currentElement);
            }
            currentElement = currentElement.eContainer();
        }
        return notationElement;
    }

    public static View findPrimaryView(EObject notationElement) {
        return CSSDOMSemanticElementHelper.findTopView(notationElement);
    }

    public static View findTopView(EObject notationElement) {
        EObject semanticElement = CSSDOMSemanticElementHelper.findSemanticElement(notationElement);
        if (semanticElement == notationElement) {
            return (View)notationElement;
        }
        EObject lastNotationElement = notationElement;
        while (notationElement != null) {
            if (CSSDOMSemanticElementHelper.findSemanticElement(notationElement = notationElement.eContainer()) != semanticElement) {
                return (View)lastNotationElement;
            }
            if (notationElement == null) continue;
            lastNotationElement = notationElement;
        }
        return (View)lastNotationElement;
    }

    public static boolean isFloatingLabel(EObject notationElement) {
        if (!(notationElement instanceof DecorationNode)) {
            return false;
        }
        DecorationNode node = (DecorationNode)notationElement;
        if (node instanceof BasicCompartment) {
            return false;
        }
        if (node.eContainer() instanceof Connector) {
            return true;
        }
        return node.eContainer() instanceof Shape && node.getLayoutConstraint() != null;
    }
}

