/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Handle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.ui.AdvancedHLManager;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkPopupBarEditPolicy
extends DiagramAssistantEditPolicy {
    private IPageIconsRegistry editorRegistry;
    private IFigure figureBar;
    private HyperLinkManagerShell hyperLinkManagerShell;
    protected List<Image> imagesToBeDisposed = new ArrayList<Image>();
    private final PopupBarMouseListener myMouseKeyListener = new PopupBarMouseListener();
    protected ArrayList<HyperLinkObject> hyperLinkObjectList;
    protected HyperLinkHelperFactory hyperlinkHelperFactory;

    public void activate() {
        super.activate();
    }

    public HyperLinkPopupBarEditPolicy() {
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        this.hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
    }

    public int addObjectList(int positonwidth, List<?> objectList) {
        int i = 0;
        while (i < objectList.size()) {
            PopupBarLabelHandle handle = null;
            ILabelProvider labelProvider = null;
            try {
                EObject contextElement = EMFHelper.getEObject((Object)this.getHost());
                labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)contextElement)).getLabelProvider();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
            if (labelProvider == null) {
                labelProvider = new LabelProvider();
            }
            handle = new PopupBarLabelHandle(this.hyperLinkObjectList.get(i), labelProvider.getImage(objectList.get(i)));
            Rectangle r1 = new Rectangle();
            r1.setLocation(positonwidth, 5);
            positonwidth += 20;
            r1.setSize(16, 16);
            Label l = new Label();
            if (labelProvider instanceof CellLabelProvider) {
                l.setText(((CellLabelProvider)labelProvider).getToolTipText((Object)this.hyperLinkObjectList.get(i)));
            } else {
                l.setText(labelProvider.getText((Object)this.hyperLinkObjectList.get(i)));
            }
            handle.setToolTip((IFigure)l);
            handle.setPreferredSize(16, 16);
            handle.setBounds(r1);
            handle.setBackgroundColor(ColorConstants.white);
            this.getFigureBar().add((IFigure)handle);
            handle.addMouseListener((MouseListener)this.myMouseKeyListener);
            handle.addMouseMotionListener((MouseMotionListener)this);
            ++i;
        }
        return positonwidth;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this.getHost());
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IFigure createPopupBarFigure() {
        this.figureBar = new RoundedRectangleWithTail();
        return this.figureBar;
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected IFigure getFigureBar() {
        return this.figureBar;
    }

    protected void hideDiagramAssistant() {
        if (this.getFigureBar() != null) {
            this.getFigureBar().removeMouseMotionListener((MouseMotionListener)this);
            this.getFigureBar().removeMouseListener((MouseListener)this.myMouseKeyListener);
            IFigure layer = this.getLayer("Handle Layer");
            if (this.getFigureBar().getParent() != null) {
                layer.remove(this.getFigureBar());
            }
            if (this.imagesToBeDisposed != null) {
                for (Object current : this.figureBar.getChildren()) {
                    if (!(current instanceof PopupBarLabelHandle)) continue;
                    ((PopupBarLabelHandle)((Object)current)).dispose();
                }
                this.imagesToBeDisposed.clear();
            }
        }
        this.figureBar = null;
    }

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof RoundedRectangleWithTail || object instanceof PopupBarLabelHandle;
    }

    protected boolean isDiagramAssistantShowing() {
        return true;
    }

    protected boolean isPreferenceOn() {
        return true;
    }

    protected int populatePopup() {
        int xLoc = 5;
        if (this.getFigureBar() != null) {
            try {
                this.hyperLinkObjectList = this.hyperlinkHelperFactory.getAllreferenced((EModelElement)((IGraphicalEditPart)this.getHost()).getNotationView());
            }
            catch (HyperLinkException e) {
                e.printStackTrace();
            }
            xLoc = this.addObjectList(xLoc, this.hyperLinkObjectList);
            PopupBarLabelPlusHandle handle = new PopupBarLabelPlusHandle();
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, 5);
            xLoc += 20;
            r1.setSize(16, 16);
            Label l = new Label();
            l.setText("Add hyperlink");
            handle.setToolTip((IFigure)l);
            handle.setPreferredSize(16, 16);
            handle.setBounds(r1);
            handle.setBackgroundColor(ColorConstants.white);
            this.getFigureBar().add((IFigure)handle);
            handle.addMouseListener((MouseListener)this.myMouseKeyListener);
            handle.addMouseMotionListener((MouseMotionListener)this);
        }
        return xLoc;
    }

    protected int getAppearanceDelay() {
        return 1000;
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.getFigureBar() == null) {
            if (referencePoint == null) {
                referencePoint = this.getHostFigure().getBounds().getCenter();
            }
            Point position = new Point(referencePoint);
            this.createPopupBarFigure();
            int width = this.populatePopup();
            IFigure layer = this.getLayer("Handle Layer");
            layer.add(this.getFigureBar());
            this.getHostFigure().translateToAbsolute((Translatable)position);
            this.getFigureBar().translateToRelative((Translatable)position);
            this.getFigureBar().setSize(width, 30);
            position.x += 15;
            this.adjustToFitInViewport(position);
            this.getFigureBar().setLocation(position);
            this.getFigureBar().setBackgroundColor(ColorConstants.white);
            this.getFigureBar().setForegroundColor(ColorConstants.orange);
            if (!this.shouldAvoidHidingDiagramAssistant()) {
                this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
            }
        }
    }

    private void adjustToFitInViewport(Point position) {
        Control control = this.getHost().getViewer().getControl();
        if (control instanceof FigureCanvas) {
            int xDiff;
            Rectangle viewportRect = ((FigureCanvas)control).getViewport().getClientArea();
            Rectangle balloonRect = new Rectangle(position, this.getFigureBar().getSize());
            int yDiff = viewportRect.y - balloonRect.y;
            if (yDiff > 0) {
                position.translate(0, yDiff);
            }
            if ((xDiff = balloonRect.right() - viewportRect.right()) > 0) {
                position.translate(-xDiff, 0);
            }
        }
    }

    protected boolean shouldShowDiagramAssistant() {
        return this.getHost().isActive() && this.isPreferenceOn() && this.isHostEditable() && this.isHostResolvable() && this.isDiagramPartActive();
    }

    private boolean isDiagramPartActive() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IWorkbenchPart activePart = page.getActivePart();
            IDiagramWorkbenchPart editorPart = null;
            if (activePart instanceof IDiagramWorkbenchPart) {
                editorPart = (IDiagramWorkbenchPart)activePart;
            } else if (activePart instanceof IAdaptable) {
                editorPart = (IDiagramWorkbenchPart)activePart.getAdapter(IDiagramWorkbenchPart.class);
            }
            if (editorPart == null) {
                return false;
            }
            return editorPart.getDiagramEditPart().getRoot().equals(((IGraphicalEditPart)this.getHost()).getRoot());
        }
        return false;
    }

    private boolean isHostEditable() {
        if (this.getHost() instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)this.getHost()).isEditModeEnabled();
        }
        return true;
    }

    private boolean isHostResolvable() {
        View view = (View)this.getHost().getModel();
        EObject element = view.getElement();
        if (element != null) {
            return !element.eIsProxy();
        }
        return true;
    }

    private class PopupBarLabelHandle
    extends Label
    implements Handle {
        private boolean myMouseOver;
        private Object myObject;

        public PopupBarLabelHandle(Object anObject, Image theImage) {
            super(theImage);
            this.myMouseOver = false;
            this.myObject = null;
            this.myObject = anObject;
            this.setOpaque(true);
            this.setBackgroundColor(ColorConstants.buttonLightest);
        }

        public void dispose() {
        }

        public Point getAccessibleLocation() {
            return null;
        }

        public DragTracker getDragTracker() {
            return null;
        }

        public Object getReferencedObject() {
            return this.myObject;
        }

        public void handleMouseEntered(MouseEvent event) {
            super.handleMouseEntered(event);
            this.setBackgroundColor(ColorConstants.button);
            this.myMouseOver = true;
        }

        public void handleMouseExited(MouseEvent event) {
            super.handleMouseExited(event);
            this.setBackgroundColor(ColorConstants.white);
            this.myMouseOver = false;
        }

        public void handleMousePressed(MouseEvent event) {
            int cfr_ignored_0 = event.button;
            super.handleMousePressed(event);
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.myMouseOver) {
                Rectangle area = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
            }
        }

        protected void paintFigure(Graphics graphics) {
            Image theImage;
            if (!this.isEnabled() && (theImage = this.getIcon()) != null) {
                graphics.translate(this.bounds.x, this.bounds.y);
                graphics.drawImage(theImage, this.getIconLocation());
                graphics.translate(-this.bounds.x, -this.bounds.y);
                return;
            }
            super.paintFigure(graphics);
        }
    }

    private class PopupBarLabelPlusHandle
    extends PopupBarLabelHandle {
        public PopupBarLabelPlusHandle() {
            super(null, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.common", (String)"/icons/obj16/Plus.gif").createImage());
        }
    }

    private class PopupBarMouseListener
    extends MouseListener.Stub {
        private PopupBarMouseListener() {
        }

        public void mouseReleased(MouseEvent me) {
            super.mouseReleased(me);
        }

        public void mousePressed(MouseEvent me) {
            if (3 == me.button) {
                HyperLinkPopupBarEditPolicy.this.hideDiagramAssistant();
            }
            if (1 == me.button) {
                if (me.getSource() instanceof PopupBarLabelPlusHandle) {
                    HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell = new AdvancedHLManager(HyperLinkPopupBarEditPolicy.this.getEditorRegistry(), ((IGraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getEditingDomain(), (EModelElement)((IGraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView().getElement(), ((IGraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView(), HyperLinkPopupBarEditPolicy.this.hyperlinkHelperFactory);
                    HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell.setInput(HyperLinkPopupBarEditPolicy.this.hyperLinkObjectList);
                    HyperLinkPopupBarEditPolicy.this.hideDiagramAssistant();
                    HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell.open();
                    me.consume();
                } else if (me.getSource() instanceof PopupBarLabelHandle) {
                    if (((PopupBarLabelHandle)((Object)me.getSource())).getReferencedObject() instanceof HyperLinkObject) {
                        final HyperLinkObject hyperLinkObject = (HyperLinkObject)((PopupBarLabelHandle)((Object)me.getSource())).getReferencedObject();
                        if (hyperLinkObject.needsOpenCommand()) {
                            try {
                                TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)HyperLinkPopupBarEditPolicy.this.getHost());
                                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Open hyperlink"){

                                    protected void doExecute() {
                                        hyperLinkObject.openLink();
                                    }
                                });
                            }
                            catch (ServiceException serviceException) {}
                        } else {
                            hyperLinkObject.openLink();
                        }
                    }
                    me.consume();
                }
                HyperLinkPopupBarEditPolicy.this.hideDiagramAssistant();
            }
            super.mousePressed(me);
        }
    }

    private class RoundedRectangleWithTail
    extends RoundedRectangle {
        public RoundedRectangleWithTail() {
            this.setFill(true);
            this.setBackgroundColor(ColorConstants.yellow);
            this.setForegroundColor(ColorConstants.orange);
            this.setVisible(true);
            this.setEnabled(true);
            this.setOpaque(true);
        }
    }
}

