/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.infra.gmfdiag.preferences.messages.Messages;
import org.eclipse.papyrus.infra.tools.preferences.ui.dialog.AbstractApplyValueOnPreferenceKeyDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ApplyValueOnPreferenceKeyDialog
extends AbstractApplyValueOnPreferenceKeyDialog {
    public ApplyValueOnPreferenceKeyDialog(String[] keys) {
        super(keys);
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new KeyLabelProvider();
    }

    protected IContentProvider createContentProvider() {
        return new KeyContentProvider();
    }

    protected class KeyContentProvider
    implements IStructuredContentProvider {
        protected KeyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < ApplyValueOnPreferenceKeyDialog.this.keys.length) {
                if (ApplyValueOnPreferenceKeyDialog.this.keys[i].startsWith("DIAGRAM_")) {
                    result.add(ApplyValueOnPreferenceKeyDialog.this.keys[i]);
                }
                if (ApplyValueOnPreferenceKeyDialog.this.keys[i].startsWith("ELEMENT_")) {
                    result.add(ApplyValueOnPreferenceKeyDialog.this.keys[i]);
                }
                ++i;
            }
            return result.toArray();
        }
    }

    protected static class KeyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        protected KeyLabelProvider() {
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element.toString().startsWith("ELEMENT_")) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.infra.gmfdiag.preferences", "/icons/pref.gif");
                }
                if (element.toString().startsWith("DIAGRAM_")) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.infra.gmfdiag.preferences", "/icons/diag.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String initialKey = element.toString();
            String out = initialKey.toString();
            if (columnIndex == 0) {
                out = out.substring(out.indexOf(".") + 1, out.length()).toUpperCase();
            }
            if (columnIndex == 1) {
                if (element.toString().startsWith("ELEMENT_")) {
                    return Messages.ApplyValueOnPreferenceKeyDialog_ELEMENT;
                }
                if (element.toString().startsWith("DIAGRAM_")) {
                    return Messages.ApplyValueOnPreferenceKeyDialog_DIAGRAM;
                }
            }
            if (columnIndex == 2) {
                String beforePoint;
                if (initialKey.startsWith("ELEMENT_") && (out = initialKey.toString().replaceAll("ELEMENT_", "")).indexOf(".") > 0 && (beforePoint = out.substring(0, out.indexOf("."))).lastIndexOf("_") > 0) {
                    out = String.valueOf(out.substring(beforePoint.lastIndexOf("_") + 1, out.indexOf("."))) + " (" + beforePoint.substring(0, beforePoint.lastIndexOf("_")) + ")";
                }
                if (initialKey.startsWith("DIAGRAM_")) {
                    out = initialKey.toString().replaceAll("DIAGRAM_", "");
                    out = out.substring(0, out.indexOf("."));
                }
            }
            return out;
        }
    }
}

