/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.common.modelresource.PapyrusNattableModel;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCreateNattableEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.runAsTransaction(event);
        }
        catch (ServiceException e) {
            throw new ExecutionException("Can't create TableEditor", (Throwable)e);
        }
        return null;
    }

    public String askName() {
        ResourceSetImpl set = new ResourceSetImpl();
        Resource res = set.getResource(this.getTableEditorConfigurationURI(), true);
        TableConfiguration conf = (TableConfiguration)res.getContents().get(0);
        String defaultName = conf.getName();
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)NattablePackage.eINSTANCE.getTable(), (EStructuralFeature)NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name(), (String)defaultName, (EObject)this.getTableContext());
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.AbstractCreateNattableEditorHandler_PapyrusTableCreation, Messages.AbstractCreateNattableEditorHandler_EnterTheNameForTheNewTable, nameWithIncrement, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public void runAsTransaction(ExecutionEvent event) throws ServiceException {
        String name = this.askName();
        if (name != null) {
            this.runAsTransaction(event, name);
        }
    }

    public void runAsTransaction(ExecutionEvent event, final String name) throws ServiceException {
        final ServicesRegistry serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
        TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                try {
                    AbstractCreateNattableEditorHandler.this.doExecute(serviceRegistry, name, this.description);
                }
                catch (NotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        });
    }

    public Command getCreateNattableEditorCommandWithNameInitialization(TransactionalEditingDomain domain, final ServicesRegistry serviceRegistry, ExecutionEvent event, final String name) throws ServiceException {
        return new RecordingCommand(domain){

            protected void doExecute() {
                try {
                    AbstractCreateNattableEditorHandler.this.doExecute(serviceRegistry, name, this.description);
                }
                catch (NotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        };
    }

    public Table doExecute(ServicesRegistry serviceRegistry, String name, String description) throws ServiceException, NotFoundException {
        Table editorModel = this.createEditorModel(serviceRegistry, name, description);
        IPageManager pageMngr = ServiceUtils.getInstance().getIPageManager((Object)serviceRegistry);
        pageMngr.openPage((Object)editorModel);
        return editorModel;
    }

    protected Table createEditorModel(ServicesRegistry serviceRegistry, String name, String description) throws ServiceException, NotFoundException {
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)serviceRegistry);
        TableConfiguration configuration = this.getDefaultTableEditorConfiguration((ResourceSet)modelSet);
        Assert.isNotNull((Object)configuration);
        Table table = TableHelper.createTable((TableConfiguration)configuration, null, (String)name, (String)description);
        PapyrusNattableModel model = (PapyrusNattableModel)modelSet.getModelChecked("org.eclipse.papyrus.infra.nattable.resource.NattableModel");
        table.setContext(this.getTableContext());
        model.addPapyrusTable(table);
        return table;
    }

    protected TableConfiguration getDefaultTableEditorConfiguration(ResourceSet resourceSet) {
        Resource resource = resourceSet.getResource(this.getTableEditorConfigurationURI(), true);
        TableConfiguration tableConfiguration = null;
        if (resource.getContents().get(0) instanceof TableConfiguration) {
            tableConfiguration = (TableConfiguration)resource.getContents().get(0);
        }
        return tableConfiguration;
    }

    protected abstract URI getTableEditorConfigurationURI();

    protected EObject getTableContext() {
        List<EObject> selection = this.getSelection();
        if (!selection.isEmpty()) {
            return selection.get(0);
        }
        return null;
    }

    protected List<EObject> getSelection() {
        ISelection selection;
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (selection = ww.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                EObject currentEObject = EMFHelper.getEObject(object);
                if (currentEObject == null) continue;
                selectedElements.add(currentEObject);
            }
        }
        return selectedElements;
    }

    protected EObject getRootElement(Resource modelResource) {
        Object root;
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0 && (root = modelResource.getContents().get(0)) instanceof EObject) {
            rootElement = (EObject)root;
        }
        return rootElement;
    }
}

