/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.modelresource;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class PapyrusNattableModel
extends AbstractModelWithSharedResource<Table>
implements IModel {
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.nattable.resource.NattableModel";
    public static final String TABLE_MODEL_FILE_EXTENSION = "notation";

    public void init(ModelSet modelManager) {
        super.init(modelManager);
    }

    protected String getModelFileExtension() {
        return TABLE_MODEL_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void addPapyrusTable(Table tableInstance) {
        try {
            TransactionalEditingDomain editingDomain = ServiceUtilsForResourceSet.getInstance().getTransactionalEditingDomain((Object)this.modelSet);
            Resource notationResource = NotationUtils.getNotationResourceForDiagram((EObject)tableInstance.getContext(), (TransactionalEditingDomain)editingDomain);
            notationResource.getContents().add((Object)tableInstance);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void removeTable(Table tableInstance) {
        this.getResource().getContents().remove((Object)tableInstance);
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof Table;
    }
}

