/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.nattable.provider.AbstractNattableCellLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class GenericCellLabelProvider
extends AbstractNattableCellLabelProvider {
    public static final int MAX_DISPLAYED_ELEMENTS = 10;

    @Override
    public boolean accept(Object element) {
        return element instanceof ILabelProviderCellContextElementWrapper;
    }

    @Override
    public String getText(Object element) {
        ILabelProviderCellContextElementWrapper contextElement = (ILabelProviderCellContextElementWrapper)element;
        IConfigRegistry registry = ((ILabelProviderContextElementWrapper)element).getConfigRegistry();
        Object value = contextElement.getObject();
        LabelProviderService service = this.getLabelProviderService(registry);
        return this.getText(service, value);
    }

    protected String getText(LabelProviderService service, Object value) {
        StringBuffer label = new StringBuffer();
        if (value instanceof Collection) {
            label.append(this.getCollectionText(service, (Collection)value));
        } else {
            label.append(service.getLabelProvider(value).getText(value));
        }
        return label.toString();
    }

    private boolean isDisplayCollectionHooks() {
        return false;
    }

    private boolean isDisplayBigCollection() {
        return false;
    }

    protected String getCollectionText(LabelProviderService service, Collection<?> value) {
        StringBuffer label = new StringBuffer();
        Iterator<?> iter = value.iterator();
        if (this.isDisplayCollectionHooks()) {
            label.append("[");
        }
        int i = 1;
        while (iter.hasNext()) {
            if (i > 10) {
                if (!this.isDisplayBigCollection()) break;
                label.append("...");
                break;
            }
            Object current = iter.next();
            label.append(this.getElementText(service, current));
            if (iter.hasNext()) {
                label.append(", ");
            }
            ++i;
        }
        if (this.isDisplayCollectionHooks()) {
            label.append("]");
        }
        return label.toString();
    }

    protected String getElementText(LabelProviderService service, Object value) {
        return service.getLabelProvider(value).getText(value);
    }
}

