/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.papyrus.infra.nattable.provider.ProblemLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.internal.SharedImages;

public class PapyrusNatTableToolTipProvider
extends NatTableContentTooltip {
    private final ISharedImages sharedImage = new SharedImages();

    public PapyrusNatTableToolTipProvider(NatTable natTable, String ... tooltipRegions) {
        super(natTable, tooltipRegions);
    }

    protected Image getImage(Event event) {
        if (this.isCellWithError(event)) {
            return this.sharedImage.getImage("IMG_OBJS_ERROR_TSK");
        }
        return super.getImage(event);
    }

    protected String getText(Event event) {
        if (this.isCellWithError(event)) {
            ILayerCell cell = this.getCell(event);
            return this.getProblemTooltip(cell.getDataValue());
        }
        return super.getText(event);
    }

    protected String getProblemTooltip(Object value) {
        ProblemLabelProvider provider = new ProblemLabelProvider();
        if (value instanceof Problem) {
            return provider.getTooltipText((EObject)value);
        }
        if (value instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            Iterator iter = ((Collection)value).iterator();
            while (iter.hasNext()) {
                Object current = iter.next();
                if (current instanceof Problem) {
                    builder.append(provider.getTooltipText((EObject)current));
                }
                if (!iter.hasNext()) continue;
                builder.append("\n");
            }
            return builder.toString();
        }
        return null;
    }

    protected ILayerCell getCell(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        return this.natTable.getCellByPosition(col, row);
    }

    protected boolean isCellWithError(Event event) {
        ILayerCell cell = this.getCell(event);
        boolean hasError = false;
        if (cell != null) {
            Object value = cell.getDataValue();
            if (value instanceof Problem) {
                hasError = true;
            } else if (value instanceof Collection) {
                Iterator iter = ((Collection)value).iterator();
                while (!hasError && iter.hasNext()) {
                    hasError = iter.next() instanceof Problem;
                }
            }
        }
        return hasError;
    }

    protected boolean shouldCreateToolTip(Event event) {
        if (this.isCellWithError(event)) {
            return true;
        }
        return !this.isDisplayingFullCellText(event);
    }

    protected boolean isDisplayingFullCellText(Event event) {
        return true;
    }
}

