/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlResourceCommand;

public class CreateControlResource
extends AbstractControlResourceCommand {
    public CreateControlResource(ControlModeRequest request) {
        super(request, "Create a control resource", null);
    }

    public CreateControlResource(ControlModeRequest request, String newFileExtension) {
        this(request);
        this.newFileExtension = newFileExtension;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Resource newResource;
        boolean resourceInSet;
        Resource resource = this.getResourceSet().getResource(this.getTargetUri(), false);
        boolean bl = resourceInSet = resource != null;
        if (resourceInSet) {
            if (this.failedToLoadBecauseNonExistent(resource) || this.isNotYetDeteted(resource)) {
                resource.getResourceSet().getResources().remove((Object)resource);
                resource = null;
                resourceInSet = false;
            } else {
                return CommandResult.newErrorCommandResult((String)"The resource is already in the resource set");
            }
        }
        if ((newResource = this.getResourceSet().createResource(this.getTargetUri())) == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to create new resource to control");
        }
        this.getRequest().setTargetResource(newResource, this.getFileExtension());
        newResource.setModified(true);
        this.getRequest().getModelSet().getResourcesToDeleteOnSave().remove(newResource.getURI());
        return CommandResult.newOKCommandResult((Object)newResource);
    }

    protected boolean isNotYetDeteted(Resource resource) {
        boolean result = false;
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            result = ((ModelSet)resourceSet).getResourcesToDeleteOnSave().contains(resource.getURI());
        }
        return result;
    }

    protected boolean failedToLoadBecauseNonExistent(Resource resource) {
        boolean result = false;
        if (resource.getContents().isEmpty() && !resource.getErrors().isEmpty()) {
            result = !resource.getResourceSet().getURIConverter().exists(resource.getURI(), null);
        }
        return result;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus superStatus = super.doUndo(monitor, info);
        Resource oldResource = this.getRequest().getTargetResource(this.getFileExtension());
        this.getResourceSet().getResources().remove((Object)oldResource);
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to get model set").getStatus();
        }
        modelSet.getResourcesToDeleteOnSave().add(oldResource.getURI());
        return superStatus;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Resource oldResource = this.getRequest().getTargetResource(this.getFileExtension());
        this.getResourceSet().getResources().add((Object)oldResource);
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)"Unable to get model set").getStatus();
        }
        modelSet.getResourcesToDeleteOnSave().remove(oldResource.getURI());
        oldResource.setModified(true);
        return super.doRedo(monitor, info);
    }
}

