/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CreateModelFragmentDialog
extends ResourceDialog {
    private static final String DIALOG_TITLE = "Submodel Resource";
    private URI uri;
    private Resource currentResource;
    private String defaultName;

    public CreateModelFragmentDialog(Shell parent, Resource theCurrentResource, String defaultName) {
        super(parent, DIALOG_TITLE, 8192);
        this.currentResource = theCurrentResource;
        this.defaultName = defaultName;
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IFile file = null;
                String path = URI.createURI((String)CreateModelFragmentDialog.this.computeDefaultURI()).lastSegment();
                file = WorkspaceResourceDialog.openNewFile((Shell)CreateModelFragmentDialog.this.getShell(), null, null, (IPath)(path != null ? new Path(path) : null), null);
                if (file != null) {
                    CreateModelFragmentDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                }
            }
        });
    }

    public String computeDefaultURI() {
        String ext = this.currentResource.getURI().fileExtension();
        URI uri = this.currentResource.getURI().trimSegments(1);
        uri = uri.appendSegment(this.defaultName).appendFileExtension(ext);
        return uri.toString();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.uriField.setText(this.computeDefaultURI());
        return result;
    }

    protected boolean processResources() {
        URI uri;
        this.uri = uri = URI.createURI((String)this.getURIText());
        return true;
    }

    public URI getURI() {
        return this.uri;
    }
}

