/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.pluginexplorer.Plugin;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginEntry;
import org.eclipse.papyrus.infra.viewpoints.configuration.ChildRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.ModelAutoCreate;
import org.eclipse.papyrus.infra.viewpoints.configuration.ModelRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.OwningRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.PaletteRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusConfiguration;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusViewpoint;
import org.eclipse.papyrus.infra.viewpoints.configuration.PathElement;
import org.eclipse.papyrus.infra.viewpoints.iso42010.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.viewpoints.iso42010.ModelKind;
import org.eclipse.papyrus.infra.viewpoints.iso42010.Stakeholder;
import org.eclipse.papyrus.infra.viewpoints.policy.Activator;
import org.eclipse.papyrus.infra.viewpoints.policy.IProfileHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData;
import org.eclipse.papyrus.infra.viewpoints.policy.ProfileUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.RuleConstraintManager;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.viewpoints.policy.WeightedConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyChecker {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.viewpoints.policy.custom";
    private static final Map<String, PapyrusConfiguration> CONFIGURATIONS_CACHE = new HashMap<String, PapyrusConfiguration>();
    private static final ResourceSet CONFIGURATIONS_RESOURCE_SET = new ResourceSetImpl();
    private static final PapyrusConfiguration CONFIG_BUILTIN_DEFAULT = PolicyChecker.loadDefaultConfiguration("builtin/default.configuration");
    private static final boolean DEFAULT_POLICY_UNKNOWN_CHILD = false;
    private static final boolean DEFAULT_POLICY_UNKNWON_PALETTE = true;
    private static final int RESULT_PERMIT = 1;
    private static final int RESULT_UNKNOWN = 0;
    private static final int RESULT_DENY = -1;
    private static Map<String, Collection<String>> CONTRIBUTIONS_DEFINITON = null;
    private static Map<PapyrusConfiguration, Collection<PapyrusConfiguration>> CONTRIBUTIONS_CACHE = null;
    private static PolicyChecker currentPolicyChecker;
    private PapyrusConfiguration configuration;
    private boolean oneViewPerElem;
    private Stakeholder selectedStakeholder;
    private PapyrusViewpoint selectedViewpoint;
    private Collection<PapyrusViewpoint> applicableViewpoints;
    private IProfileHelper profileHelper;

    private static PapyrusConfiguration loadDefaultConfiguration(String name) {
        Plugin me = new Plugin(Activator.getDefault().getBundle());
        PluginEntry entry = me.getEntry(name);
        return PolicyChecker.loadConfigurationFrom(entry.getLogicalPath());
    }

    public static PapyrusConfiguration loadConfigurationFrom(String location) {
        block6: {
            block5: {
                try {
                    if (location != null) break block5;
                    return null;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
            if (!location.isEmpty()) break block6;
            return null;
        }
        URI uri = null;
        uri = location.startsWith("platform:/") ? URI.createURI((String)location) : URI.createFileURI((String)location);
        location = uri.toString();
        PapyrusConfiguration config = CONFIGURATIONS_CACHE.get(location);
        if (config != null) {
            return config;
        }
        Resource res = CONFIGURATIONS_RESOURCE_SET.getResource(uri, true);
        config = (PapyrusConfiguration)res.getContents().get(0);
        CONFIGURATIONS_CACHE.put(location, config);
        return config;
    }

    public static PapyrusConfiguration getDefaultConfiguration() {
        return CONFIG_BUILTIN_DEFAULT;
    }

    private static Collection<PapyrusViewpoint> getContributionsTo(PapyrusViewpoint viewpoint) {
        ArrayList<PapyrusViewpoint> result = new ArrayList<PapyrusViewpoint>();
        Collection<PapyrusConfiguration> contributions = PolicyChecker.getContributionsTo((PapyrusConfiguration)viewpoint.eContainer());
        for (PapyrusConfiguration contrib : contributions) {
            for (ArchitectureViewpoint vp : contrib.getViewpoints()) {
                if (!(vp instanceof PapyrusViewpoint) || !vp.getName().equals(viewpoint.getName())) continue;
                result.add((PapyrusViewpoint)vp);
            }
        }
        return result;
    }

    private static Collection<PapyrusConfiguration> getContributionsTo(PapyrusConfiguration config) {
        Collection<PapyrusConfiguration> result;
        if (CONTRIBUTIONS_CACHE == null) {
            PolicyChecker.loadContributions();
        }
        if ((result = CONTRIBUTIONS_CACHE.get(config)) != null) {
            return result;
        }
        result = new ArrayList<PapyrusConfiguration>();
        CONTRIBUTIONS_CACHE.put(config, result);
        for (Map.Entry<String, PapyrusConfiguration> entry : CONFIGURATIONS_CACHE.entrySet()) {
            if (entry.getValue() != config) continue;
            Collection<String> contribURIs = CONTRIBUTIONS_DEFINITON.get(entry.getKey());
            if (contribURIs != null) {
                for (String uri : contribURIs) {
                    result.add(PolicyChecker.loadConfigurationFrom(uri));
                }
            }
            return result;
        }
        return result;
    }

    private static void loadContributions() {
        CONTRIBUTIONS_DEFINITON = new HashMap<String, Collection<String>>();
        CONTRIBUTIONS_CACHE = new HashMap<PapyrusConfiguration, Collection<PapyrusConfiguration>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i != extensions.length) {
            String plugin = extensions[i].getContributor().getName();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j != elements.length) {
                if (elements[j].getName().equals("contribution")) {
                    String uriOriginal = PolicyChecker.getCanonicalURI(plugin, elements[j].getAttribute("original"));
                    String uriContrib = PolicyChecker.getCanonicalURI(plugin, elements[j].getAttribute("file"));
                    Collection<String> list = CONTRIBUTIONS_DEFINITON.get(uriOriginal);
                    if (list == null) {
                        list = new ArrayList<String>();
                        CONTRIBUTIONS_DEFINITON.put(uriOriginal, list);
                    }
                    list.add(uriContrib);
                }
                ++j;
            }
            ++i;
        }
    }

    private static String getCanonicalURI(String plugin, String uri) {
        if (uri.startsWith("platform:/plugin/")) {
            return uri;
        }
        return "platform:/plugin/" + plugin + "/" + uri;
    }

    public static IPreferenceStore getPreferences() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static PolicyChecker getCurrent() {
        if (currentPolicyChecker == null) {
            currentPolicyChecker = new PolicyChecker();
        }
        return currentPolicyChecker;
    }

    public static void setCurrent(PolicyChecker pc) {
        currentPolicyChecker = pc;
    }

    public PapyrusConfiguration getConfiguration() {
        return this.configuration;
    }

    public Stakeholder getStakeholder() {
        return this.selectedStakeholder;
    }

    public PapyrusViewpoint getViewpoint() {
        return this.selectedViewpoint;
    }

    private PolicyChecker() {
        IPreferenceStore store = PolicyChecker.getPreferences();
        String prefType = store.getString("papyrusViewpointsConfigurationType");
        String prefForce = store.getString("papyrusViewpointsForceMultiplicity");
        String prefViewpoint = store.getString("papyrusViewpointsSelectedViewpoint");
        this.profileHelper = ProfileUtils.getProfileHelper();
        this.oneViewPerElem = "true".equals(prefForce);
        if ("default".equals(prefType)) {
            this.configuration = CONFIG_BUILTIN_DEFAULT;
        } else if ("extension".equals(prefType)) {
            WeightedConfiguration wc = WeightedConfiguration.getTopConfiguration();
            this.configuration = wc != null ? wc.getConfiguration() : null;
        } else {
            String scheme = store.getString("papyrusViewpointsUserDefinedScheme");
            String path = store.getString("papyrusViewpointsUserDefinedConfiguration");
            if ("platform:/resource/".equals(scheme)) {
                path = "platform:/resource/" + path;
            }
            this.configuration = PolicyChecker.loadConfigurationFrom(path);
        }
        if (this.configuration == null) {
            this.configuration = CONFIG_BUILTIN_DEFAULT;
        }
        if (prefViewpoint != null && !prefViewpoint.isEmpty()) {
            for (Stakeholder stakeholder : this.configuration.getStakeholders()) {
                for (ArchitectureViewpoint vp : stakeholder.getViewpoints()) {
                    if (!prefViewpoint.equals(vp.getName())) continue;
                    this.selectedStakeholder = stakeholder;
                    this.selectedViewpoint = (PapyrusViewpoint)vp;
                    this.buildApplicableViewpoints();
                    return;
                }
            }
        }
        this.selectedStakeholder = this.configuration.getDefaultStakeholder();
        this.selectedViewpoint = (PapyrusViewpoint)this.selectedStakeholder.getViewpoints().get(0);
        this.buildApplicableViewpoints();
    }

    public PolicyChecker(boolean oneViewPerElem) {
        this.configuration = CONFIG_BUILTIN_DEFAULT;
        this.oneViewPerElem = oneViewPerElem;
        this.selectedStakeholder = this.configuration.getDefaultStakeholder();
        this.selectedViewpoint = (PapyrusViewpoint)this.selectedStakeholder.getViewpoints().get(0);
        this.profileHelper = ProfileUtils.getProfileHelper();
        this.buildApplicableViewpoints();
    }

    public PolicyChecker(PapyrusConfiguration config, PapyrusViewpoint viewpoint, boolean oneViewPerElem) {
        this.configuration = config;
        this.oneViewPerElem = oneViewPerElem;
        this.selectedViewpoint = viewpoint;
        this.profileHelper = ProfileUtils.getProfileHelper();
        this.buildApplicableViewpoints();
        for (Stakeholder stakeholder : this.configuration.getStakeholders()) {
            if (!stakeholder.getViewpoints().contains((Object)viewpoint)) continue;
            this.selectedStakeholder = stakeholder;
            return;
        }
    }

    private void buildApplicableViewpoints() {
        this.applicableViewpoints = new ArrayList<PapyrusViewpoint>();
        this.buildApplicableViewpoints(this.selectedViewpoint);
        for (PapyrusViewpoint vp : PolicyChecker.getContributionsTo(this.selectedViewpoint)) {
            this.buildApplicableViewpoints(vp);
        }
    }

    private void buildApplicableViewpoints(PapyrusViewpoint from) {
        PapyrusViewpoint vp = from;
        while (vp != null) {
            this.applicableViewpoints.add(vp);
            vp = vp.getParent();
        }
    }

    public boolean canHaveNewView(EObject element, EObject owner, ViewPrototype prototype) {
        if (prototype == null) {
            return false;
        }
        if (!this.matchesProfiles(prototype.configuration, this.profileHelper.getAppliedProfiles(owner))) {
            return false;
        }
        if (!this.matchesProfiles(prototype.configuration, this.profileHelper.getAppliedProfiles(element))) {
            return false;
        }
        return this.matchesCreationRoot(prototype.configuration, element, this.profileHelper.getAppliedStereotypes(element), prototype.getViewCountOn(element));
    }

    public ModelAddData getChildAddData(Diagram diagram, EObject parent, EObject child) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return new ModelAddData(false);
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.configuration;
        Collection<EClass> stereotypes = this.profileHelper.getAppliedStereotypes(child);
        while (config != null) {
            for (ChildRule rule : config.getChildRules()) {
                int result = this.allows(rule, parent.eClass(), child.eClass(), stereotypes);
                if (result == 0) continue;
                return new ModelAddData(result == 1, (EList<PathElement>)rule.getInsertionPath());
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return new ModelAddData(false);
    }

    public ModelAddData getChildAddData(Diagram diagram, EClass parentType, EClass childType) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return new ModelAddData(false);
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.configuration;
        while (config != null) {
            for (ChildRule rule : config.getChildRules()) {
                int result = this.allows(rule, parentType, childType, new ArrayList<EClass>(0));
                if (result == 0) continue;
                return new ModelAddData(result == 1, (EList<PathElement>)rule.getInsertionPath());
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return new ModelAddData(false);
    }

    public boolean isInPalette(Diagram diagram, String entryID) {
        ViewPrototype prototype = ViewPrototype.get((EObject)diagram);
        if (prototype == null) {
            return false;
        }
        PapyrusDiagram config = (PapyrusDiagram)prototype.configuration;
        while (config != null) {
            for (PaletteRule rule : config.getPaletteRules()) {
                int result = this.allows(rule, entryID);
                if (result == 0) continue;
                return result == 1;
            }
            config = (PapyrusDiagram)config.getParent();
        }
        return true;
    }

    public boolean isInViewpoint(PapyrusView config) {
        for (PapyrusViewpoint viewpoint : this.applicableViewpoints) {
            for (ModelKind kind : viewpoint.getModelKinds()) {
                PapyrusView view = (PapyrusView)kind;
                if (!EcoreUtil.equals((EObject)view, (EObject)config)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<ViewPrototype> getAllPrototypes() {
        ArrayList<ViewPrototype> result = new ArrayList<ViewPrototype>();
        for (PapyrusViewpoint viewpoint : this.applicableViewpoints) {
            for (ModelKind kind : viewpoint.getModelKinds()) {
                PapyrusView view = (PapyrusView)kind;
                ViewPrototype proto = ViewPrototype.get(view);
                if (proto == null) continue;
                result.add(proto);
            }
        }
        return result;
    }

    public Collection<ViewPrototype> getPrototypesFor(EObject element) {
        ArrayList<ViewPrototype> result = new ArrayList<ViewPrototype>();
        Collection<EPackage> profiles = this.profileHelper.getAppliedProfiles(element);
        Collection<EClass> stereotypes = this.profileHelper.getAppliedStereotypes(element);
        for (PapyrusViewpoint viewpoint : this.applicableViewpoints) {
            for (ModelKind kind : viewpoint.getModelKinds()) {
                int count;
                OwningRule rule;
                ViewPrototype proto;
                PapyrusView view = (PapyrusView)kind;
                if (!this.matchesProfiles(view, profiles) || (proto = ViewPrototype.get(view)) == null || (rule = this.matchesCreationOwner(view, element, stereotypes, count = proto.getOwnedViewCount(element))) == null) continue;
                if (rule.getNewModelPath() != null && !rule.getNewModelPath().isEmpty()) {
                    result.add(proto);
                    continue;
                }
                count = proto.getViewCountOn(element);
                if (!this.matchesCreationRoot(view, element, stereotypes, count)) continue;
                result.add(proto);
            }
        }
        return result;
    }

    public OwningRule getOwningRuleFor(ViewPrototype prototype, EObject owner) {
        Collection<EClass> stereotypes = this.profileHelper.getAppliedStereotypes(owner);
        int count = prototype.getOwnedViewCount(owner);
        OwningRule rule = this.matchesCreationOwner(prototype.configuration, owner, stereotypes, count);
        return rule;
    }

    protected PapyrusView getViewFrom(String implem, EObject owner, EObject root) {
        for (PapyrusViewpoint viewpoint : this.applicableViewpoints) {
            for (ModelKind kind : viewpoint.getModelKinds()) {
                PapyrusView view = (PapyrusView)kind;
                if (!this.matches(view, implem, owner, root)) continue;
                return view;
            }
        }
        return null;
    }

    private boolean matches(PapyrusView view, String implem, EObject owner, EObject root) {
        if (!ViewPrototype.isNatural(view)) {
            return false;
        }
        if (!view.getImplementationID().equals(implem)) {
            return false;
        }
        if (owner != null) {
            if (!this.matchesProfiles(view, this.profileHelper.getAppliedProfiles(owner))) {
                return false;
            }
            if (!this.matchesExistingOwner(view, owner, this.profileHelper.getAppliedStereotypes(owner))) {
                return false;
            }
        }
        if (root != null) {
            if (!this.matchesProfiles(view, this.profileHelper.getAppliedProfiles(root))) {
                return false;
            }
            if (!this.matchesExistingRoot(view, root, this.profileHelper.getAppliedStereotypes(root))) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesProfiles(PapyrusView view, Collection<EPackage> profiles) {
        PapyrusView current = view;
        while (current != null) {
            for (EPackage profile : view.getProfiles()) {
                if (profiles.contains(profile)) continue;
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    private boolean matchesExistingOwner(PapyrusView view, EObject owner, Collection<EClass> stereotypes) {
        PapyrusView current = view;
        while (current != null) {
            for (OwningRule rule : current.getOwningRules()) {
                int result = this.allows(rule, owner, stereotypes);
                if (result == -1) {
                    return false;
                }
                if (result != 1) continue;
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private OwningRule matchesCreationOwner(PapyrusView view, EObject owner, Collection<EClass> stereotypes, int count) {
        PapyrusView current = view;
        while (current != null) {
            for (OwningRule rule : current.getOwningRules()) {
                int multiplicity;
                int allow = this.allows(rule, owner, stereotypes);
                if (allow == -1) {
                    return null;
                }
                if (allow == 0 || (multiplicity = rule.getMultiplicity()) != -1 && count >= multiplicity || !this.allows(rule, owner)) continue;
                return rule;
            }
            current = current.getParent();
        }
        return null;
    }

    private boolean matchesExistingRoot(PapyrusView view, EObject root, Collection<EClass> stereotypes) {
        PapyrusView current = view;
        while (current != null) {
            for (ModelRule rule : current.getModelRules()) {
                int result = this.allows(rule, root, stereotypes);
                if (result == -1) {
                    return false;
                }
                if (result != 1) continue;
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private boolean matchesCreationRoot(PapyrusView view, EObject root, Collection<EClass> stereotypes, int count) {
        PapyrusView current = view;
        while (current != null) {
            for (ModelRule rule : current.getModelRules()) {
                int multiplicity;
                int allow = this.allows(rule, root, stereotypes);
                if (allow == -1) {
                    return false;
                }
                if (allow == 0) continue;
                int n = multiplicity = this.oneViewPerElem ? 1 : rule.getMultiplicity();
                if (multiplicity != -1 && count >= multiplicity) continue;
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private int allows(OwningRule rule, EObject owner, Collection<EClass> stereotypes) {
        EClass c = rule.getElement();
        if (c == null || c.isSuperTypeOf(owner.eClass())) {
            for (EClass stereotype : rule.getStereotypes()) {
                if (stereotypes.contains(stereotype)) continue;
                return 0;
            }
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private boolean allows(OwningRule rule, EObject owner) {
        EList list = rule.getNewModelPath();
        if (list == null || list.isEmpty()) {
            return true;
        }
        EObject current = owner;
        for (ModelAutoCreate elem : list) {
            EReference ref = elem.getFeature();
            if (ref.isMany()) {
                return true;
            }
            Object e = current.eGet((EStructuralFeature)ref);
            if (e == null) {
                return true;
            }
            current = (EObject)e;
        }
        return false;
    }

    private int allows(ModelRule rule, EObject element, Collection<EClass> stereotypes) {
        EClass c = rule.getElement();
        if (c == null || c.isSuperTypeOf(element.eClass())) {
            for (EClass stereotype : rule.getStereotypes()) {
                if (stereotypes.contains(stereotype)) continue;
                return 0;
            }
            boolean ruleMatches = RuleConstraintManager.getInstance().matchRule(rule, element);
            if (!ruleMatches) {
                return 0;
            }
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private int allows(ChildRule rule, EClass origin, EClass element, Collection<EClass> stereotypes) {
        EClass ce = rule.getElement();
        EClass co = rule.getOrigin();
        if ((ce == null || ce.isSuperTypeOf(element)) && (co == null || co.isSuperTypeOf(origin))) {
            for (EClass stereotype : rule.getStereotypes()) {
                if (stereotypes.contains(stereotype)) continue;
                return 0;
            }
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }

    private int allows(PaletteRule rule, String toolID) {
        String elem = rule.getElement();
        boolean applies = elem == null;
        applies = applies || elem.length() == 0;
        applies = applies || elem != null && elem.equals(toolID);
        boolean bl = applies = applies || elem != null && elem.endsWith("*") && toolID.startsWith(elem.substring(0, elem.length() - 1));
        if (applies) {
            return rule.isPermit() ? 1 : -1;
        }
        return 0;
    }
}

