/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.migration;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;

public class BDDReconcilier
extends DiagramReconciler {
    public ICommand getReconcileCommand(Diagram diagram) {
        return new BDDReconcileCommand(diagram);
    }

    protected class BDDReconcileCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public BDDReconcileCommand(Diagram diagram) {
            super("Migrate BDD Diagram");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            EObject element = this.diagram.getElement();
            if (element instanceof Class) {
                Class clazz = (Class)element;
                this.diagram.setElement((EObject)clazz.getNearestPackage());
                DiagramUtils.setOwner((Diagram)this.diagram, (EObject)element);
            } else if (element instanceof DataType) {
                DataType datatype = (DataType)element;
                this.diagram.setElement((EObject)datatype.getNearestPackage());
                DiagramUtils.setOwner((Diagram)this.diagram, (EObject)element);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

