/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.matcher.FlowSpecificationMatcher;
import org.eclipse.papyrus.sysml.service.types.matcher.RequirementMatcher;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.EMFUtil;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BlockEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public BlockEditHelperAdvice() {
        this.requiredProfiles.add(BlocksPackage.eINSTANCE);
    }

    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest editContextRequest;
        boolean isApproved = super.approveRequest(request);
        if (request != null && request instanceof GetEditContextRequest && (editContextRequest = (GetEditContextRequest)request).getEditContext() instanceof Element) {
            Object matcher = new FlowSpecificationMatcher();
            Element contextElement = (Element)editContextRequest.getEditContext();
            if (matcher.matches((EObject)contextElement)) {
                isApproved = false;
            }
            if ((matcher = new RequirementMatcher()).matches((EObject)contextElement)) {
                isApproved = false;
            }
        }
        return isApproved;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)element, BlocksPackage.eINSTANCE.getBlock());
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)BlocksPackage.eINSTANCE.getBlock().getName(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        EObject source;
        IElementType type = request.getElementType();
        if (this.hasSuperType(type, (IElementType)SysMLElementTypes.ASSOCIATION) && EMFUtil.isReadOnly((EObject)(source = request.getSource()))) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected boolean hasSuperType(IElementType elementType, IElementType typeToTest) {
        if (elementType == null || typeToTest == null) {
            return false;
        }
        if (elementType.equals(typeToTest)) {
            return true;
        }
        List<IElementType> superTypes = Arrays.asList(elementType.getAllSuperTypes());
        return superTypes.contains(typeToTest);
    }
}

