/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        List<IElementType> superTypes;
        IElementType type = request.getElementType();
        if (SysMLElementTypes.ASSOCIATION.equals(type)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (type != null && (superTypes = Arrays.asList(type.getAllSuperTypes())).contains(SysMLElementTypes.ASSOCIATION)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getBeforeDestroyReferenceCommand(DestroyReferenceRequest request) {
        ICommand gmfCommand = super.getBeforeDestroyReferenceCommand(request);
        Association association = (Association)request.getContainer();
        if (request.getContainingFeature() == UMLPackage.eINSTANCE.getAssociation_MemberEnd() && association.getMemberEnds().contains((Object)request.getReferencedObject())) {
            HashSet ends = new HashSet();
            ends.addAll(association.getMemberEnds());
            ends.remove(request.getReferencedObject());
            if (ends.size() <= 2) {
                DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)association, false);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)association);
                if (provider != null) {
                    ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyCommand);
                }
            }
        }
        return gmfCommand;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Association association = (Association)request.getElementToConfigure();
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                ElementUtil.addNature((Element)association, (String)"SysML_Nature");
                return CommandResult.newOKCommandResult((Object)association);
            }
        };
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest req) {
        ArrayList<Property> dependentsToDestroy = new ArrayList<Property>();
        List dependentsToKeep = RequestParameterUtils.getDependentsToKeep((IEditCommandRequest)req) != null ? RequestParameterUtils.getDependentsToKeep((IEditCommandRequest)req) : new ArrayList();
        Association association = (Association)req.getElementToDestroy();
        for (Property end : association.getMemberEnds()) {
            if (dependentsToKeep.contains(end)) continue;
            dependentsToDestroy.add(end);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return req.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return super.getBeforeDestroyDependentsCommand(req);
    }

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        IElementEditService provider;
        List currentlyRefactoredElements;
        ICommand gmfCommand = super.getBeforeReorientRelationshipCommand(request);
        MoveRequest moveRequest = null;
        SetRequest setTypeRequest = null;
        Association association = (Association)request.getRelationship();
        List list = currentlyRefactoredElements = RequestParameterUtils.getAssociationRefactoredElements((IEditCommandRequest)request) != null ? RequestParameterUtils.getAssociationRefactoredElements((IEditCommandRequest)request) : new ArrayList();
        if (currentlyRefactoredElements.contains(association)) {
            return null;
        }
        RequestParameterUtils.addAssociationRefactoredElement((IEditCommandRequest)request, (EObject)association);
        if (request.getNewRelationshipEnd() instanceof Association) {
            return UnexecutableCommand.INSTANCE;
        }
        Property semanticSource = (Property)association.getMemberEnds().get(0);
        Property semanticTarget = (Property)association.getMemberEnds().get(1);
        Property modifiedPropertyType = null;
        if (request.getDirection() == 1) {
            if (!association.getOwnedEnds().contains((Object)semanticSource)) {
                moveRequest = new MoveRequest(request.getNewRelationshipEnd(), (EObject)semanticSource);
            }
            modifiedPropertyType = semanticTarget;
            setTypeRequest = new SetRequest((EObject)modifiedPropertyType, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)request.getNewRelationshipEnd());
        }
        if (request.getDirection() == 2) {
            if (!association.getOwnedEnds().contains((Object)semanticTarget)) {
                moveRequest = new MoveRequest(request.getNewRelationshipEnd(), (EObject)semanticTarget);
            }
            modifiedPropertyType = semanticSource;
            setTypeRequest = new SetRequest((EObject)modifiedPropertyType, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)request.getNewRelationshipEnd());
        }
        if (moveRequest != null) {
            moveRequest.addParameters(request.getParameters());
            provider = ElementEditServiceUtils.getCommandProvider((Object)request.getNewRelationshipEnd());
            if (provider != null) {
                ICommand moveCommand = provider.getEditCommand((IEditCommandRequest)moveRequest);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)moveCommand);
            }
        }
        if (setTypeRequest != null) {
            setTypeRequest.addParameters(request.getParameters());
            provider = ElementEditServiceUtils.getCommandProvider((Object)modifiedPropertyType);
            if (provider != null) {
                ICommand setTypeCommand = provider.getEditCommand((IEditCommandRequest)setTypeRequest);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)setTypeCommand);
            }
        }
        HashSet<View> viewsToDestroy = new HashSet<View>();
        viewsToDestroy.addAll(this.getViewsToDestroy(association, request));
        if (!viewsToDestroy.isEmpty()) {
            DestroyDependentsRequest ddr = new DestroyDependentsRequest(request.getEditingDomain(), request.getRelationship(), false);
            ddr.setClientContext(request.getClientContext());
            ddr.addParameters(request.getParameters());
            ICommand destroyViewsCommand = ddr.getDestroyDependentsCommand(viewsToDestroy);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyViewsCommand);
        }
        if (gmfCommand != null) {
            gmfCommand.reduce();
        }
        return gmfCommand;
    }

    private Set<View> getViewsToDestroy(Association association, ReorientRelationshipRequest request) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        EReference[] refs = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
        Collection associationViews = EMFCoreUtil.getReferencers((EObject)association, (EReference[])refs);
        Edge currentlyReorientedView = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
        viewsToDestroy.addAll(associationViews);
        viewsToDestroy.remove(currentlyReorientedView);
        return viewsToDestroy;
    }
}

