/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.edit.part.interfaces.InterruptibleEdge;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.ActivityEdge;

public class InterruptibleEdgeEditPolicy
extends AbstractEditPolicy {
    public static String INTERRUPTIBLE_ICON_POLICY = "interruptibleIconPolicy";

    public void activate() {
        this.validateConsistency();
        super.activate();
    }

    protected void validateConsistency() {
        try {
            final IGraphicalEditPart graphicalHost = (IGraphicalEditPart)this.getHost();
            final InterruptibleEdge interruptibleEdge = (InterruptibleEdge)this.getHost();
            EObject resolveSemanticElement = graphicalHost.resolveSemanticElement();
            ActivityEdge activityEdgeAux = resolveSemanticElement instanceof ActivityEdge ? (ActivityEdge)resolveSemanticElement : null;
            ActivityEdge activityEdge = activityEdgeAux;
            final View interruptbleEdgeIcon = this.getInterruptbleEdgeIcon(graphicalHost, interruptibleEdge);
            if (activityEdge != null) {
                if (activityEdge.getInterrupts() == null && interruptbleEdgeIcon != null) {
                    AbstractTransactionalCommand destroyCommand = new AbstractTransactionalCommand(graphicalHost.getEditingDomain(), "Destroy Interruptible Edge Icon", null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            ViewUtil.destroy((View)interruptbleEdgeIcon);
                            return CommandResult.newOKCommandResult();
                        }
                    };
                    this.executeCommand((Command)new ICommandProxy((ICommand)destroyCommand));
                }
                if (activityEdge.getInterrupts() != null && interruptbleEdgeIcon == null) {
                    AbstractTransactionalCommand createCommand = new AbstractTransactionalCommand(graphicalHost.getEditingDomain(), "Create Interruptible Edge Icon", null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Object model = graphicalHost.getModel();
                            if (model != null) {
                                Node node = ViewService.createNode((View)((View)model), (String)UMLVisualIDRegistry.getType(interruptibleEdge.getInterruptibleEdgeIconVisualID()), (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                                if (node != null) {
                                    return CommandResult.newOKCommandResult((Object)node);
                                }
                                return CommandResult.newErrorCommandResult((String)"Unable to create the view for Interruptible Edge label");
                            }
                            return null;
                        }
                    };
                    this.executeCommand((Command)new ICommandProxy((ICommand)createCommand));
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The host of InterruptibleEdgeEditPolicy should implement IGraphicalEditPart and InterruptibleEdge which refer to an ActivityEdge");
        }
    }

    private View getInterruptbleEdgeIcon(IGraphicalEditPart graphicalHost, InterruptibleEdge interruptibleEdge) {
        View view = graphicalHost.getNotationView();
        if (view != null) {
            return ViewUtil.getChildBySemanticHint((View)view, (String)String.valueOf(interruptibleEdge.getInterruptibleEdgeIconVisualID()));
        }
        return null;
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"executeCommand", (Throwable)e);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeCommand", (Throwable)e);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        return this.getHost();
    }

    protected int getInterruptibleEdgeIconID() {
        return this.getInterruptibleEdgeIcon().getInterruptibleEdgeIconVisualID();
    }

    protected InterruptibleEdge getInterruptibleEdgeIcon() {
        return (InterruptibleEdge)this.getHost();
    }

    protected ActivityEdge getActivtyEdge() {
        EObject eObject = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (eObject instanceof ActivityEdge) {
            return (ActivityEdge)eObject;
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        EditingDomain editinDomain;
        EditPart getHost = this.getHost();
        if (getHost instanceof GraphicalEditPart) {
            GraphicalEditPart host = (GraphicalEditPart)getHost;
            return host.getEditingDomain();
        }
        Object view = getHost.getModel();
        if (view instanceof EObject && (editinDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)view))) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)editinDomain;
        }
        return null;
    }
}

