/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;

public class LinkedBehaviorLocator
extends AdvancedBorderItemLocator {
    private static final int MARGIN = 5;

    public LinkedBehaviorLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public LinkedBehaviorLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public LinkedBehaviorLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = proposedLocation.getCopy();
        if (this.getParentBorder().intersects(proposedLocation)) {
            int heightGap = this.getParentBorder().y - proposedLocation.y - proposedLocation.height - 5;
            realLocation.translate(0, heightGap);
        }
        return realLocation;
    }

    public void relocate(IFigure borderItem) {
        Rectangle validLocation = this.getCorrectItemLocation(borderItem);
        borderItem.setBounds(validLocation);
        this.setCurrentSideOfParent(LinkedBehaviorLocator.findClosestSideOfParent((Rectangle)borderItem.getBounds(), (Rectangle)this.getParentBorder()));
    }

    public Rectangle getCorrectItemLocation(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        return this.getValidLocation(rectSuggested, borderItem);
    }
}

