/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class PinParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String STATE_DISPLAY = System.getProperty("line.separator").concat("[%s]");
    private static final String STATE_SEPARATOR = ", ";

    public PinParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public PinParser(EAttribute[] features) {
        super(features);
    }

    public PinParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        StringBuffer label = new StringBuffer();
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof Pin) {
            Pin pin = (Pin)obj;
            String name = pin.getName();
            if (name == null) {
                name = "";
            }
            label.append(name);
            if (pin.getInStates() != null) {
                StringBuffer stateLabel = new StringBuffer();
                for (State state : pin.getInStates()) {
                    if (state == null) continue;
                    String stateName = state.getName();
                    if (stateName == null) {
                        stateName = "";
                    }
                    if ("".equals(stateName)) continue;
                    if (stateLabel.length() > 0) {
                        stateLabel.append(STATE_SEPARATOR);
                    }
                    stateLabel.append(stateName);
                }
                if (stateLabel.length() > 0) {
                    label.append(String.format(STATE_DISPLAY, stateLabel.toString()));
                }
            }
        }
        if (label.length() == 0) {
            label.append(" ");
        }
        return label.toString();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof Pin) {
            Pin pin = (Pin)element;
            semanticElementsBeingParsed.add(pin);
            if (pin.getInStates() != null) {
                for (State state : pin.getInStates()) {
                    if (state == null) continue;
                    semanticElementsBeingParsed.add(state);
                }
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getObjectNode_InState().equals(feature);
    }
}

