/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.tabbedproperties.appearance;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ForkNodeEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.JoinNodeEditPart;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ForkNode;
import org.eclipse.papyrus.uml.diagram.common.ui.helper.HelpComponentFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class SwitchSegmentDirectionSection
extends AbstractNotationPropertiesSection {
    private static final String ICON_PATH = "icons/switchSegmentOrientation.gif";
    public static Image switchImage = null;
    protected IGraphicalEditPart editPart;

    static {
        try {
            switchImage = new Image((Device)Display.getDefault(), UMLDiagramEditorPlugin.getInstance().getBundle().getResource(ICON_PATH).openStream());
        }
        catch (IOException e) {
            UMLDiagramEditorPlugin.getInstance().logError(e.getMessage(), e);
        }
    }

    public void initializeControls(Composite parent) {
        super.initializeControls(parent);
        GridLayout layout = new GridLayout(2, false);
        Group switchGroup = this.getWidgetFactory().createGroup(this.composite, CustomMessages.ForkJoinSegmentSwitchOrientation_actionLabel);
        switchGroup.setLayout((Layout)layout);
        Button button = new Button((Composite)switchGroup, 8);
        button.setImage(switchImage);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SwitchSegmentDirectionSection.this.switchSelectedSegmentsOrientation();
                SwitchSegmentDirectionSection.this.refresh();
            }
        });
        ImageHyperlink help = HelpComponentFactory.createHelpComponent((Composite)switchGroup, (FormToolkit)this.getWidgetFactory(), (String)CustomMessages.ForkJoinSegmentSwitchOrientation_helpMessage);
        gd = new GridData(131072, 0x1000000, false, true);
        help.setLayoutData((Object)gd);
        help.setBackground(switchGroup.getBackground());
    }

    protected void switchSelectedSegmentsOrientation() {
        CommandStack stack;
        CompositeCommand globalCommand = new CompositeCommand(CustomMessages.ForkJoinSegmentSwitchOrientation_actionLabel);
        List editparts = this.getInput();
        for (Object part : editparts) {
            Object view = null;
            ForkNode figure = null;
            if (part instanceof JoinNodeEditPart) {
                view = ((JoinNodeEditPart)((Object)part)).getModel();
                figure = ((JoinNodeEditPart)((Object)part)).getPrimaryShape();
            } else if (part instanceof ForkNodeEditPart) {
                view = ((ForkNodeEditPart)((Object)part)).getModel();
                figure = ((ForkNodeEditPart)((Object)part)).getPrimaryShape();
            }
            if (!(view instanceof View) || figure == null) continue;
            TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
            SwitchSegmentOrientation switchCom = new SwitchSegmentOrientation(editingdomain, (Figure)figure, (View)view);
            globalCommand.add((IUndoableOperation)switchCom);
        }
        if (!globalCommand.isEmpty() && globalCommand.canExecute() && (stack = (CommandStack)EditorUtils.getMultiDiagramEditor().getAdapter(CommandStack.class)) != null) {
            stack.execute((Command)new ICommandProxy((ICommand)globalCommand));
        }
    }

    private class SwitchSegmentOrientation
    extends AbstractTransactionalCommand {
        private Figure selectedFigure;
        private View selectedView;

        SwitchSegmentOrientation(TransactionalEditingDomain domain, Figure figure, View view) {
            super(domain, CustomMessages.ForkJoinSegmentSwitchOrientation_actionLabel, null);
            this.selectedFigure = null;
            this.selectedView = null;
            this.selectedFigure = figure;
            this.selectedView = view;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.selectedFigure == null || this.selectedView == null) {
                return CommandResult.newCancelledCommandResult();
            }
            Dimension newSize = this.selectedFigure.getSize().getTransposed();
            Point newLocation = this.selectedFigure.getLocation().getCopy();
            newLocation.translate((newSize.height - newSize.width) / 2, (newSize.width - newSize.height) / 2);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)newLocation.x);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)newLocation.y);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)newSize.width);
            ViewUtil.setStructuralFeatureValue((View)this.selectedView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)newSize.height);
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return this.selectedFigure != null && this.selectedView != null;
        }

        public boolean canRedo() {
            return this.selectedFigure != null && this.selectedView != null;
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doExecute(monitor, info);
        }

        protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doExecute(monitor, info);
        }
    }
}

