/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.InstanceSpecificationLinkHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.ui.AssociationSelectionDialog;
import org.eclipse.papyrus.uml.diagram.clazz.edit.commands.InstanceSpecificationLinkCreateCommand;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CInstanceSpecificationLinkCreateCommand
extends InstanceSpecificationLinkCreateCommand {
    protected HashSet<Association> commonAssociations;

    public CInstanceSpecificationLinkCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
    }

    @Override
    public boolean canExecute() {
        if (this.source != null && this.target == null) {
            InstanceSpecification instance;
            if (this.source instanceof InstanceSpecification && (instance = (InstanceSpecification)this.source).getClassifiers().size() > 0) {
                HashSet<Association> assoSource = this.getInstanceAssociations(instance);
                return assoSource.size() > 0;
            }
            return false;
        }
        if (this.source != null && this.target != null) {
            if (!(this.source instanceof InstanceSpecification)) {
                return false;
            }
            if (!(this.target instanceof InstanceSpecification)) {
                return false;
            }
            if (((InstanceSpecification)this.source).getClassifiers().size() == 0 || ((InstanceSpecification)this.target).getClassifiers().size() == 0) {
                return false;
            }
            HashSet<Association> assoSource = this.getInstanceAssociations((InstanceSpecification)this.source);
            HashSet<Association> assoTarget = this.getInstanceAssociations((InstanceSpecification)this.target);
            assoSource.retainAll(assoTarget);
            this.commonAssociations = new HashSet();
            this.commonAssociations.addAll(assoSource);
            return this.commonAssociations.size() > 0;
        }
        return false;
    }

    private HashSet<Association> getInstanceAssociations(InstanceSpecification instance) {
        HashSet<Association> instanceAssociationsSet = new HashSet<Association>();
        for (Classifier classifier : this.getSpecificationClassifier(instance)) {
            instanceAssociationsSet.addAll((Collection<Association>)classifier.getAssociations());
        }
        return instanceAssociationsSet;
    }

    private Set<Classifier> getSpecificationClassifier(InstanceSpecification instance) {
        HashSet<Classifier> specificationClassicfiersSet = new HashSet<Classifier>();
        for (Classifier classifier : instance.getClassifiers()) {
            if (specificationClassicfiersSet.contains(classifier)) continue;
            specificationClassicfiersSet.add(classifier);
            specificationClassicfiersSet.addAll(this.getInheritedClassifier(classifier, null));
        }
        return specificationClassicfiersSet;
    }

    private Set<Classifier> getInheritedClassifier(Classifier classifier, Set<Classifier> alreadyParsedClassifier) {
        HashSet<Classifier> generalizationClassifiers = new HashSet<Classifier>();
        HashSet<Classifier> parsedClassifiersSet = new HashSet<Classifier>();
        if (alreadyParsedClassifier != null) {
            parsedClassifiersSet.addAll(alreadyParsedClassifier);
        }
        if (!parsedClassifiersSet.contains(classifier)) {
            parsedClassifiersSet.add(classifier);
            EList classifierGeneralizations = classifier.parents();
            generalizationClassifiers.addAll((Collection<Classifier>)classifierGeneralizations);
            for (Classifier generalClassifier : classifierGeneralizations) {
                generalizationClassifiers.addAll(this.getInheritedClassifier(generalClassifier, parsedClassifiersSet));
            }
        }
        return generalizationClassifiers;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Association selectedAssociation = null;
        if (((InstanceSpecification)this.source).getClassifiers().size() > 0 && ((InstanceSpecification)this.target).getClassifiers().size() > 0) {
            AssociationSelectionDialog associationSelectionDialog = new AssociationSelectionDialog(new Shell(), 8, this.commonAssociations);
            associationSelectionDialog.open();
            selectedAssociation = associationSelectionDialog.getSelectedAssociation();
            if (selectedAssociation != null) {
                InstanceSpecification instanceSpecification = UMLFactory.eINSTANCE.createInstanceSpecification();
                this.getContainer().getPackagedElements().add((Object)instanceSpecification);
                instanceSpecification.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)instanceSpecification.eClass().getName(), (Collection)instanceSpecification.getOwner().eContents()));
                instanceSpecification.getClassifiers().add((Object)selectedAssociation);
                Type sourceType = ((Property)selectedAssociation.getMemberEnds().get(0)).getType();
                Set<Classifier> sourceSpecificationClassifiersSet = this.getSpecificationClassifier((InstanceSpecification)this.source);
                if (sourceSpecificationClassifiersSet.contains(sourceType)) {
                    InstanceSpecificationLinkHelper.addEnd(instanceSpecification, (InstanceSpecification)this.source);
                    InstanceSpecificationLinkHelper.addEnd(instanceSpecification, (InstanceSpecification)this.target);
                } else {
                    InstanceSpecificationLinkHelper.addEnd(instanceSpecification, (InstanceSpecification)this.target);
                    InstanceSpecificationLinkHelper.addEnd(instanceSpecification, (InstanceSpecification)this.source);
                }
                Iterator proIterator = selectedAssociation.getMemberEnds().iterator();
                Set<Classifier> targetSpecificationClassifiersSet = this.getSpecificationClassifier((InstanceSpecification)this.target);
                while (proIterator.hasNext()) {
                    Property property = (Property)proIterator.next();
                    Slot slot = UMLFactory.eINSTANCE.createSlot();
                    slot.setDefiningFeature((StructuralFeature)property);
                    if (sourceSpecificationClassifiersSet.contains(property.getOwner())) {
                        ((InstanceSpecification)this.source).getSlots().add((Object)slot);
                        this.associateValue((InstanceSpecification)this.target, slot, property.getType());
                        continue;
                    }
                    if (targetSpecificationClassifiersSet.contains(property.getOwner())) {
                        ((InstanceSpecification)this.target).getSlots().add((Object)slot);
                        this.associateValue((InstanceSpecification)this.source, slot, property.getType());
                        continue;
                    }
                    instanceSpecification.getSlots().add((Object)slot);
                    if (sourceSpecificationClassifiersSet.contains(property.getType())) {
                        this.associateValue((InstanceSpecification)this.source, slot, property.getType());
                        continue;
                    }
                    this.associateValue((InstanceSpecification)this.target, slot, property.getType());
                }
                return CommandResult.newOKCommandResult((Object)instanceSpecification);
            }
        }
        return CommandResult.newCancelledCommandResult();
    }

    protected InstanceValue associateValue(InstanceSpecification instanceSpecification, Slot owner, Type type) {
        InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
        instanceValue.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)instanceValue.eClass().getName(), (Collection)owner.eContents()));
        instanceValue.setType(type);
        instanceValue.setInstance(instanceSpecification);
        owner.getValues().add((Object)instanceValue);
        return instanceValue;
    }
}

