/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PackageFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PackageNodePlateFigure;

public class ContainmentCircleOnPackageLocator
extends BorderItemLocator {
    private static final Dimension DEFAULT_BORDER_ITEM_OFFSET = new Dimension(1, 1);
    private static final Dimension DEFAULT_SIZE = new Dimension(20, 20);
    private Dimension originalBorderItemOffset = DEFAULT_BORDER_ITEM_OFFSET;

    public ContainmentCircleOnPackageLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public ContainmentCircleOnPackageLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public ContainmentCircleOnPackageLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
        this.setConstraint(new Rectangle(new Point(0, 0), DEFAULT_SIZE));
    }

    public void setConstraint(Rectangle theConstraint) {
        super.setConstraint(new Rectangle(theConstraint.getTopLeft(), DEFAULT_SIZE));
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle headerBounds;
        PackageFigure parent = this.getParentPackageFigure();
        Rectangle rectangle = headerBounds = parent == null ? null : parent.getHeader();
        if (headerBounds != null && suggestedSide == 1 && !this.isOnHeader(suggestedLocation, headerBounds)) {
            this.setBorderItemOffset(new Dimension(this.originalBorderItemOffset.width, headerBounds.height));
        } else {
            this.setBorderItemOffset(this.originalBorderItemOffset);
        }
        Point result = super.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        this.setBorderItemOffset(this.originalBorderItemOffset);
        return result;
    }

    private PackageFigure getParentPackageFigure() {
        SVGNodePlateFigure svgNodePlateFigure;
        IFigure parentFigure = this.getParentFigure();
        if (parentFigure instanceof PackageNodePlateFigure) {
            return ((PackageNodePlateFigure)parentFigure).getPackageFigure();
        }
        if (parentFigure instanceof SVGNodePlateFigure && (svgNodePlateFigure = (SVGNodePlateFigure)parentFigure).getChildren().size() > 0 && svgNodePlateFigure.getChildren().get(0) instanceof PackageFigure) {
            return (PackageFigure)svgNodePlateFigure.getChildren().get(0);
        }
        return null;
    }

    private boolean isOnHeader(Point p, Rectangle headerBounds) {
        return p.x < headerBounds.getTopRight().x;
    }
}

