/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.diagram.common.util.MultiDiagramUtil;

public class AddEObjectReferencesToDiagram
extends AbstractTransactionalCommand {
    private Diagram diagram = null;
    private List<EObject> eObjects = null;
    protected boolean addContents = true;

    public AddEObjectReferencesToDiagram(TransactionalEditingDomain domain, Diagram diagram, List<EObject> eObjects) {
        super(domain, "Add EObject references to Diagram", null);
        this.diagram = diagram;
        this.eObjects = eObjects;
    }

    public AddEObjectReferencesToDiagram(TransactionalEditingDomain domain, Diagram diagram, List<EObject> eObjects, boolean addContents) {
        super(domain, "Add EObject references to Diagram", null);
        this.diagram = diagram;
        this.eObjects = eObjects;
        this.addContents = addContents;
    }

    public boolean canExecute() {
        return this.diagram != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (EObject eObject : this.eObjects) {
            this.addReferences(eObject);
        }
        return CommandResult.newOKCommandResult();
    }

    private void addReferences(EObject eObject) {
        if (this.addContents) {
            for (EObject e : eObject.eContents()) {
                this.addReferences(e);
            }
        }
        MultiDiagramUtil.AddEAnnotationReferenceToDiagram(this.diagram, eObject);
    }
}

