/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.FollowSVGSymbolEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.NameDisplayEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.uml2.uml.NamedElement;

public abstract class NamedElementEditPart
extends UMLNodeEditPart
implements IUMLNamedElementEditPart {
    public static final String DISPLAY_STEREOTYPES = "displayStereotypes";
    public static final String DISPLAY_TAGS = "displayTags";
    public static final int DEFAULT_MARGIN = 0;
    public static final String TOP_MARGIN_PROPERTY = "topMarginLabel";
    public static final String LEFT_MARGIN_PROPERTY = "leftMarginLabel";
    public static final String BOTTOM_MARGIN_PROPERTY = "bottomMarginLabel";
    public static final String RIGHT_MARGIN_PROPERTY = "rightMarginLabel";

    public NamedElementEditPart(View view) {
        super(view);
    }

    @Override
    public NamedElement getNamedElement() {
        return (NamedElement)this.getUMLElement();
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
        }
    }

    private void refreshIconNamedLabel() {
        this.getNodeNamedElementFigure().setNameLabelIcon(AppearanceHelper.showElementIcon((EModelElement)((View)this.getModel())));
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getNodeNamedElementFigure() != null && this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
            this.refreshLabelDisplay();
            this.refreshLabelMargin();
        }
    }

    private void refreshLabelMargin() {
        IFigure figure = null;
        int leftMargin = 0;
        int rightMargin = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        Object model = this.getModel();
        if (model instanceof View) {
            leftMargin = NotationUtils.getIntValue((View)((View)model), (String)LEFT_MARGIN_PROPERTY, (int)0);
            rightMargin = NotationUtils.getIntValue((View)((View)model), (String)RIGHT_MARGIN_PROPERTY, (int)0);
            topMargin = NotationUtils.getIntValue((View)((View)model), (String)TOP_MARGIN_PROPERTY, (int)0);
            bottomMargin = NotationUtils.getIntValue((View)((View)model), (String)BOTTOM_MARGIN_PROPERTY, (int)0);
        }
        if (this instanceof IPapyrusEditPart) {
            figure = this.getPrimaryShape();
            List labelChildFigureList = FigureUtils.findChildFigureInstances((IFigure)figure, IPapyrusWrappingLabel.class);
            for (IPapyrusWrappingLabel label : labelChildFigureList) {
                if (label == null) continue;
                label.setMarginLabel(leftMargin, topMargin, rightMargin, bottomMargin);
            }
        }
    }

    public void activate() {
        super.activate();
    }

    protected void refreshLabelDisplay() {
        View view = this.getNotationView();
        if (this.svgNodePlate != null) {
            if (this.svgNodePlate.hasLabelBounds()) {
                this.getNodeNamedElementFigure().getNameLabel().setTextWrap(true);
            } else {
                this.getNodeNamedElementFigure().getNameLabel().setTextWrap(false);
            }
        }
        BooleanValueStyle displayNameStyle = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "displayName");
        BooleanValueStyle displayStereotypes = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), DISPLAY_STEREOTYPES);
        BooleanValueStyle displayTags = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), DISPLAY_TAGS);
        if (displayNameStyle != null && !displayNameStyle.isBooleanValue()) {
            this.getNodeNamedElementFigure().removeNameLabel();
            this.getNodeNamedElementFigure().removeStereotypeLabel();
            this.getNodeNamedElementFigure().removeTaggedLabel();
        } else {
            this.getNodeNamedElementFigure().restoreNameLabel();
            if (displayStereotypes != null && !displayStereotypes.isBooleanValue()) {
                this.getNodeNamedElementFigure().removeStereotypeLabel();
            } else {
                this.getNodeNamedElementFigure().restoreStereotypeLabel();
            }
            if (displayTags != null && !displayTags.isBooleanValue()) {
                this.getNodeNamedElementFigure().removeTaggedLabel();
            } else {
                this.getNodeNamedElementFigure().restoreTaggedLabel();
            }
        }
    }

    @Override
    protected void refreshLabelsFont(Font font) {
        super.refreshLabelsFont(font);
        this.getNodeNamedElementFigure().getNameLabel().setFont(font);
        if (this.getNodeNamedElementFigure().getQualifiedNameLabel() != null) {
            this.getNodeNamedElementFigure().getQualifiedNameLabel().setFont(font);
        }
        if (this.getNodeNamedElementFigure().getTaggedLabel() != null) {
            this.getNodeNamedElementFigure().getTaggedLabel().setFont(font);
        }
    }

    private IPapyrusNodeNamedElementFigure getNodeNamedElementFigure() {
        return (IPapyrusNodeNamedElementFigure)this.getPrimaryShape();
    }

    @Override
    protected void setFontColor(Color color) {
        super.setFontColor(color);
        if (this.getNodeNamedElementFigure().getQualifiedNameLabel() != null) {
            this.getNodeNamedElementFigure().getQualifiedNameLabel().setForegroundColor(color);
        }
        if (this.getNodeNamedElementFigure().getTaggedLabel() != null) {
            this.getNodeNamedElementFigure().getTaggedLabel().setForegroundColor(color);
        }
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("NAME_DISPLAY_EDITPOLICY", (EditPolicy)new NameDisplayEditPolicy());
        this.installEditPolicy("followSVGSymbolEditPolicy", (EditPolicy)new FollowSVGSymbolEditPolicy());
    }

    protected NodeFigure createNodeFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }
}

