/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.HTMLCommentParser;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.common.parser.HTMLCleaner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLCornerBentFigure
extends CornerBentFigure
implements ILabelFigure,
IMultilineEditableFigure {
    protected boolean useLocalCoordinates = false;
    static final Color THIS_BACK = new Color(null, 248, 249, 214);
    private static final FontData DEFAULT_FONT = new FontData("Arial", 8, 0);
    private static final FontData CODE_SAMPLE_FONT = new FontData("Lucida Console", 8, 0);
    private static final FontData QUOTE_FONT = new FontData("Monotype Corsiva", 10, 0);
    private static final String FONT_NAME = "face";
    private static final String FONT_SIZE = "size";
    protected FlowPage page;
    private final List<List<Styles>> myStyles = new ArrayList<List<Styles>>();
    private FontData currentFontData;
    private String text = "";
    private Set<FontData> cachedFontDatas = new HashSet<FontData>();

    public HTMLCornerBentFigure() {
        this.setBackgroundColor(THIS_BACK);
        this.createContents();
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }

    protected void createContents() {
        this.page = new FlowPage();
        this.page.setForegroundColor(this.getForegroundColor());
        this.add((IFigure)this.page);
    }

    protected boolean useLocalCoordinates() {
        return this.useLocalCoordinates;
    }

    public HTMLCornerBentFigure getCornerBentFigure() {
        return this;
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setIcon(Image icon) {
    }

    @Override
    public void setText(String text) {
        if (HTMLCornerBentFigure.equals(text, this.text)) {
            return;
        }
        this.text = text;
        this.page.removeAll();
        this.currentFontData = new FontData("Wingdings", 8, 0);
        this.generateBlockForText(text, this.page);
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2.equals(s1);
    }

    protected void generateBlockForText(String text, FlowPage page) {
        NodeList nodeList = this.generateNodeList("<body>" + text + "</body>");
        this.myStyles.clear();
        if (nodeList.getLength() > 0) {
            this.generateBlocksFromNodeList(nodeList, (BlockFlow)page, new Stack<Styles>());
        } else {
            TextFlowEx textFlow = new TextFlowEx(text);
            page.add((IFigure)textFlow);
        }
    }

    protected void generateBlocksFromNodeList(NodeList nodeList, BlockFlow parentFlow, Stack<Styles> parentStyles) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            short nodeType = node.getNodeType();
            if (nodeType == 3) {
                String text = HTMLCleaner.cleanHTMLTags(node.getNodeValue());
                if (text != null && !text.trim().isEmpty()) {
                    ArrayList<Styles> styles = Collections.list(parentStyles.elements());
                    this.myStyles.add(styles);
                    this.generateTextFromTextNode(text, parentFlow, styles);
                }
            } else {
                try {
                    switch (HTMLTags.valueOf(nodeName)) {
                        case body: {
                            this.generateBlocksFromBodyNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case h3: {
                            this.generateBlocksFromH3Node(node, parentFlow, parentStyles);
                            break;
                        }
                        case h4: {
                            this.generateBlocksFromH4Node(node, parentFlow, parentStyles);
                            break;
                        }
                        case h5: {
                            this.generateBlocksFromH5Node(node, parentFlow, parentStyles);
                            break;
                        }
                        case strong: 
                        case b: {
                            this.generateBlocksFromStrongNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case em: {
                            this.generateBlocksFromItalicNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case u: {
                            this.generateBlocksFromUnderlineNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case sub: {
                            break;
                        }
                        case sup: {
                            break;
                        }
                        case blockquote: {
                            break;
                        }
                        case table: {
                            break;
                        }
                        case p: {
                            this.generateBlocksFromParagraphNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case br: {
                            this.generateBlocksFromBRNode(node, parentFlow);
                            break;
                        }
                        case font: {
                            this.generateBlocksForFontNode(node, parentFlow, parentStyles);
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    protected void generateBlocksFromUnderlineNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.underline);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    public void setFont(Font f) {
        super.setFont(f);
        List<TextFlow> textFlowList = this.findTextFlowChildList((IFigure)this.page);
        int i = 0;
        for (TextFlow nextTextFlow : textFlowList) {
            nextTextFlow.setFont(this.calculateCurrentFont(this.myStyles.get(i)));
            ++i;
        }
    }

    private List<TextFlow> findTextFlowChildList(IFigure parent) {
        ArrayList<TextFlow> result = new ArrayList<TextFlow>();
        for (Object nextFigure : parent.getChildren()) {
            if (!(nextFigure instanceof TextFlow)) {
                result.addAll(this.findTextFlowChildList((IFigure)nextFigure));
                continue;
            }
            result.add((TextFlow)nextFigure);
        }
        return result;
    }

    protected void generateTextFromTextNode(String text, BlockFlow parentFlow, List<Styles> styles) {
        TextFlowEx textFlow = new TextFlowEx(text);
        textFlow.setTextUnderline(this.getUnderLineFromStyles(styles));
        textFlow.setFont(this.calculateCurrentFont(styles));
        parentFlow.add((IFigure)textFlow);
    }

    private Font calculateCurrentFont(List<Styles> styles) {
        return this.composeFontWithStyles(this.getDefaultFontData(), styles);
    }

    private boolean getUnderLineFromStyles(List<Styles> styles) {
        boolean result = false;
        for (Styles style : styles) {
            switch (style) {
                case underline: {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private FontData getDefaultFontData() {
        boolean quote = false;
        boolean codeSample = false;
        if (codeSample) {
            return CODE_SAMPLE_FONT;
        }
        if (quote) {
            return QUOTE_FONT;
        }
        FontData fromDefaultFigure = this.getCurrentFigureFontData();
        if (fromDefaultFigure == null) {
            return DEFAULT_FONT;
        }
        return fromDefaultFigure;
    }

    private FontData getCurrentFigureFontData() {
        if (this.getFont() == null) {
            return null;
        }
        if (this.getFont().getFontData() == null || this.getFont().getFontData().length == 0) {
            return null;
        }
        return this.getFont().getFontData()[0];
    }

    private Font composeFontWithStyles(FontData defaultFontData, List<Styles> styles) {
        if (styles == null || styles.isEmpty()) {
            return (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)defaultFontData));
        }
        FontData defaultFontDataCopy = FontDescriptor.copy((FontData)defaultFontData);
        int defaultStyle = defaultFontDataCopy.getStyle();
        boolean quote = false;
        boolean codeSample = false;
        for (Styles style : styles) {
            switch (style) {
                case italic: {
                    defaultStyle |= 2;
                    break;
                }
                case strong: {
                    defaultStyle |= 1;
                    break;
                }
                case quote: {
                    quote = true;
                    break;
                }
                case code: {
                    codeSample = true;
                    break;
                }
                case font: {
                    if (Styles.font.getData().get(FONT_NAME) != null) {
                        defaultFontDataCopy.setName((String)Styles.font.getData().get(FONT_NAME));
                    }
                    if (Styles.font.getData().get(FONT_SIZE) == null) break;
                    defaultFontDataCopy.setHeight((Integer)Styles.font.getData().get(FONT_SIZE) * 2 + 4);
                    break;
                }
            }
        }
        defaultFontDataCopy.setStyle(defaultStyle);
        if (codeSample) {
            defaultFontDataCopy = CODE_SAMPLE_FONT;
        } else if (quote) {
            defaultFontDataCopy = QUOTE_FONT;
        }
        return (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)defaultFontDataCopy));
    }

    protected void generateBlocksFromStrongNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.strong);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    protected void generateBlocksFromItalicNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.italic);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    protected void generateBlocksForFontNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        Node fontNameNode = node.getAttributes().getNamedItem(FONT_NAME);
        Node fontSizeNode = node.getAttributes().getNamedItem(FONT_SIZE);
        String oldFont = "";
        int oldSize = 8;
        if (fontNameNode != null) {
            String fontName = fontNameNode.getNodeValue();
            oldFont = Styles.font.getData().get(FONT_NAME) != null ? (String)Styles.font.getData().get(FONT_NAME) : "Arial";
            Styles.font.getData().put(FONT_NAME, fontName);
            styles.push(Styles.font);
        }
        if (fontSizeNode != null) {
            int fontSize = Integer.parseInt(fontSizeNode.getNodeValue());
            oldSize = Styles.font.getData().get(FONT_SIZE) != null ? (Integer)Styles.font.getData().get(FONT_SIZE) : 2;
            Styles.font.getData().put(FONT_SIZE, fontSize);
            styles.push(Styles.font);
        }
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        if (fontNameNode != null) {
            Styles.font.getData().put(FONT_NAME, oldFont);
            styles.pop();
        }
        if (fontSizeNode != null) {
            Styles.font.getData().put(FONT_SIZE, oldSize);
            styles.pop();
        }
    }

    protected void generateBlocksFromH3Node(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.header3);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        styles.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromH4Node(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.header4);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        styles.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromH5Node(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.header5);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        styles.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    private void debug(NodeList childNodes) {
        int i = 0;
        while (i < childNodes.getLength()) {
            System.err.println("[" + i + "] " + childNodes.item(i).getNodeName());
            ++i;
        }
    }

    protected void generateBlocksFromBodyNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromParagraphNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NamedNodeMap attributes = node.getAttributes();
        Node classNode = attributes.getNamedItem("class");
        boolean hasToPop = false;
        if (classNode != null) {
            String classNodeValue = classNode.getNodeValue();
            if ("codeSample".equals(classNodeValue)) {
                hasToPop = true;
                styles.push(Styles.code);
            } else if ("quote".equals(classNodeValue)) {
                styles.push(Styles.quote);
                hasToPop = true;
            }
        }
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        if (hasToPop) {
            styles.pop();
        }
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromBRNode(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        parentFlow.add((IFigure)blockFlow);
    }

    protected NodeList generateNodeList(String text) {
        return HTMLCommentParser.parse(text);
    }

    @Override
    public Point getEditionLocation() {
        return this.getBounds().getTopLeft();
    }

    protected static enum HTMLTags {
        body(""),
        h3(""),
        h4(""),
        h5(""),
        strong(""),
        b(""),
        em(""),
        u(""),
        sub(""),
        sup(""),
        blockquote(""),
        table(""),
        p(""),
        br(""),
        font("");

        protected String data;

        private HTMLTags(String data) {
            this.data = data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getData() {
            return this.data;
        }
    }

    protected static enum Styles {
        strong,
        header3,
        header4,
        header5,
        underline,
        italic,
        code,
        subscript,
        supscript,
        quote,
        font(new HashMap<String, Object>());

        private Map<String, Object> data;

        private Styles() {
            this.data = null;
        }

        private Styles(Map<String, Object> data) {
            this.data = data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

