/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class PackageFigure
extends NodeNamedElementFigure {
    private final RectangleFigure shapeCompartment;
    protected final int GAP_X = 10;
    protected final int GAP_Y = 5;
    protected Label iconPackage = null;

    public PackageFigure() {
        this.setLayoutManager((LayoutManager)new PackageLayoutManager());
        this.setOpaque(false);
        this.shapeCompartment = new RectangleFigure();
        this.add((IFigure)this.shapeCompartment);
        this.setBorder(null);
        this.getPackageableElementFigure().setFill(false);
    }

    public void setTagIcon(Image image) {
        this.iconPackage = new Label();
        this.iconPackage.setIcon(image);
        this.add((IFigure)this.iconPackage);
    }

    public ShapeCompartmentFigure getGMFPackageableElementContainer() {
        if (this.shapeCompartment.getChildren().size() > 0) {
            return (ShapeCompartmentFigure)this.shapeCompartment.getChildren().get(0);
        }
        return null;
    }

    public RectangleFigure getPackageableElementFigure() {
        return this.shapeCompartment;
    }

    public Rectangle getHeader() {
        int indexShapeContainer = this.getChildren().indexOf(this.shapeCompartment);
        Rectangle headerBound = new Rectangle(0, 0, 0, 0);
        int i = 0;
        while (i < indexShapeContainer) {
            IFigure currentchild = (IFigure)this.getChildren().get(i);
            if (currentchild.getSize().width + 20 > headerBound.width) {
                headerBound.width = currentchild.getSize().width + 20;
            }
            headerBound.height += currentchild.getSize().height;
            ++i;
        }
        ++headerBound.height;
        headerBound.x = this.getBounds().x;
        headerBound.y = this.getBounds().y;
        headerBound.height = this.getPackageableElementFigure().getBounds().y - headerBound.y;
        if (this.iconPackage != null) {
            headerBound.width += this.iconPackage.getBounds().width;
        }
        return headerBound;
    }

    public Color getGradientColor() {
        return this.getForegroundColor();
    }

    @Override
    public void setShadow(boolean shadow) {
    }

    @Override
    public void setLineWidth(int w) {
        this.getHeader().setWidth(w);
        this.getPackageableElementFigure().setLineWidth(w);
        super.setLineWidth(w);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        graphics.drawRectangle(this.getHeader());
        super.paintBorder(graphics);
    }

    @Override
    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        super.paintBackground(graphics, rectangle);
        if (this.isUsingGradient()) {
            this.applyTransparency(graphics);
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            graphics.fillRectangle(this.getHeader());
            boolean isVertical = this.getGradientStyle() == 0;
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
            graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            graphics.fillGradient(this.getPackageableElementFigure().getBounds(), isVertical);
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillRectangle(this.getHeader());
            graphics.fillRectangle(this.getPackageableElementFigure().getBounds());
        }
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setLineWidth(this.getLineWidth());
        graphics.drawRectangle(this.getHeader());
    }

    private class PackageLayoutManager
    extends AbstractLayout {
        private PackageLayoutManager() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
            int minimumWith = 0;
            int minimumHeight = 0;
            if (PackageFigure.this.getNameLabel() != null) {
                if (PackageFigure.this.getNameLabel().getPreferredSize().width > minimumWith) {
                    minimumWith = PackageFigure.this.getNameLabel().getPreferredSize().width;
                }
                minimumHeight += PackageFigure.this.getNameLabel().getPreferredSize().height;
            }
            return new Dimension(minimumWith, minimumHeight);
        }

        public void layout(IFigure container) {
            List childrenList = container.getChildren();
            int i = 0;
            while (i < container.getChildren().size()) {
                Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
                IFigure fig = (IFigure)childrenList.get(i);
                fig.invalidate();
                Dimension pref = ((IFigure)childrenList.get(i)).getPreferredSize();
                fig.invalidate();
                Dimension prefConstraint = ((IFigure)childrenList.get(i)).getPreferredSize(container.getBounds().width - 40, -1);
                if (pref.width < prefConstraint.width) {
                    bound.setSize(pref);
                } else {
                    bound.setSize(prefConstraint);
                }
                if (((IFigure)childrenList.get(i)).equals(PackageFigure.this.iconPackage)) {
                    Rectangle boundName = PackageFigure.this.getNameLabel().getBounds().getCopy();
                    boundName.x += 5;
                    PackageFigure.this.iconPackage.setBounds(new Rectangle(boundName.getTopRight(), new Dimension(16, 16)));
                } else {
                    if (i > 0) {
                        bound.y = ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1;
                        bound.x = PackageFigure.this.getBounds().x + 10;
                    } else {
                        bound.x = PackageFigure.this.getBounds().x + 10;
                        bound.y = PackageFigure.this.getBounds().y + 5;
                    }
                    ((IFigure)childrenList.get(i)).setBounds(bound);
                }
                ++i;
            }
            Rectangle lastRectangle = PackageFigure.this.getPackageableElementFigure().getBounds();
            lastRectangle.height = PackageFigure.this.getBounds().y + PackageFigure.this.getBounds().height - lastRectangle.y;
            lastRectangle.x = container.getBounds().x;
            lastRectangle.width = PackageFigure.this.getBounds().width;
            PackageFigure.this.getGMFPackageableElementContainer();
        }
    }
}

