/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;

public class RectangularShadowBorder
extends LineBorder {
    int borderwidth;

    public RectangularShadowBorder(int borderwidth, Color color) {
        super(color);
        this.borderwidth = borderwidth;
        this.setWidth(1);
    }

    public Insets getInsets(IFigure figure) {
        Insets insetsNew = super.getInsets(figure);
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.bottom + this.borderwidth);
        insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.right + this.borderwidth);
        return insetsNew;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.pushState();
        tempRect.setBounds(RectangularShadowBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RectangularShadowBorder.tempRect.width;
            --RectangularShadowBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRectangle(tempRect);
        Rectangle newRect = new Rectangle(tempRect);
        newRect.width += this.borderwidth;
        newRect.height += this.borderwidth;
        graphics.setClip(newRect);
        PointList plt = new PointList();
        plt.addPoint(RectangularShadowBorder.tempRect.x + RectangularShadowBorder.tempRect.width, RectangularShadowBorder.tempRect.y + this.borderwidth);
        plt.addPoint(RectangularShadowBorder.tempRect.x + RectangularShadowBorder.tempRect.width, RectangularShadowBorder.tempRect.y + RectangularShadowBorder.tempRect.height);
        plt.addPoint(RectangularShadowBorder.tempRect.x + this.borderwidth, RectangularShadowBorder.tempRect.y + RectangularShadowBorder.tempRect.height);
        plt.addPoint(RectangularShadowBorder.tempRect.x + this.borderwidth, RectangularShadowBorder.tempRect.y + RectangularShadowBorder.tempRect.height + this.borderwidth);
        plt.addPoint(RectangularShadowBorder.tempRect.x + RectangularShadowBorder.tempRect.width + this.borderwidth, RectangularShadowBorder.tempRect.y + RectangularShadowBorder.tempRect.height + this.borderwidth);
        plt.addPoint(RectangularShadowBorder.tempRect.x + RectangularShadowBorder.tempRect.width + this.borderwidth, RectangularShadowBorder.tempRect.y + this.borderwidth);
        plt.addPoint(RectangularShadowBorder.tempRect.x + RectangularShadowBorder.tempRect.width, RectangularShadowBorder.tempRect.y + this.borderwidth);
        if (this.getColor() != null) {
            graphics.setBackgroundColor(this.getColor());
        } else {
            graphics.setBackgroundColor(ColorConstants.black);
        }
        graphics.fillPolygon(plt);
        graphics.popState();
    }
}

