/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import com.google.common.base.Optional;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;

public class DeleteFromModelCommandHandler
extends GraphicalCommandHandler
implements IHandler {
    @Override
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Delete From Model");
        for (IGraphicalEditPart editPart : editParts) {
            Command curCommand;
            if (editPart instanceof DiagramEditPart || (curCommand = editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)))) == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    @Override
    protected boolean computeEnabled() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        IReadOnlyHandler2 readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
        for (IGraphicalEditPart editPart : this.getSelectedElements()) {
            Optional result;
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            View graphical = NotationHelper.findView((Object)editPart);
            if (readOnly == null) continue;
            LinkedList<URI> uris = new LinkedList<URI>();
            if (semantic == null || semantic == graphical) {
                return false;
            }
            if (semantic.eContainer() == null) {
                return false;
            }
            uris.add(EcoreUtil.getURI((EObject)semantic));
            if (graphical != null) {
                uris.add(EcoreUtil.getURI((EObject)graphical));
            }
            if (!(result = readOnly.anyReadOnly(ReadOnlyAxis.anyAxis(), uris.toArray(new URI[uris.size()]))).isPresent() || !((Boolean)result.get()).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

