/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.diagram.common.service.PapyrusPaletteService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.ProfileApplication;

public class PaletteProfileApplicationListener
implements IPapyrusListener {
    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof ProfileApplication && 1 == notification.getEventType()) {
            try {
                ProfileApplication profileApplication = (ProfileApplication)notification.getNotifier();
                IEditorPart editor = ServiceUtilsForEObject.getInstance().getNestedActiveIEditorPart((Object)profileApplication);
                if (editor == null) {
                    return;
                }
                Display display = editor.getSite().getWorkbenchWindow().getShell().getDisplay();
                if (display != null && display != Display.getCurrent()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PaletteProfileApplicationListener.this.updatePaletteService();
                        }
                    });
                } else {
                    this.updatePaletteService();
                }
            }
            catch (ServiceException profileApplication) {
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected void updatePaletteService() {
        PapyrusPaletteService.getInstance().providerChanged(new ProviderChangeEvent((IProvider)PapyrusPaletteService.getInstance()));
    }
}

