/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.figures;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.activity.figures.ActivityFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.InteractionFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LeftToolbarLayout;

public class ActivityAsInteractionFigure
extends ActivityFigure {
    private PapyrusWrappingLabel interactionHeader;
    private RectangleFigure interactionLabelContainer;
    private RectangleFigure interactionContentPane;

    public ActivityAsInteractionFigure() {
        this.createContents();
        this.corner = 0;
    }

    protected void createContents() {
        this.add((IFigure)this.createInteractionFigureHeader());
        this.add((IFigure)this.createContentPane());
        this.setLayoutManager((LayoutManager)new ActivityLayoutManager());
    }

    protected RectangleFigure createContentPane() {
        this.interactionContentPane = new RectangleFigure();
        this.interactionContentPane.setBorder((Border)new MarginBorder(5, 5, 5, 5));
        this.interactionContentPane.setFill(false);
        this.interactionContentPane.setOutline(false);
        return this.interactionContentPane;
    }

    protected RectangleFigure createInteractionFigureHeader() {
        this.interactionHeader = new PapyrusWrappingLabel(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                Dimension preferredSize = super.getPreferredSize(wHint, hHint);
                if (preferredSize.width == 0) {
                    return preferredSize;
                }
                return new Dimension(preferredSize.width + 2, preferredSize.height + 2);
            }
        };
        InteractionFigure interactionFigure = new InteractionFigure();
        interactionFigure.setBorder((Border)new MarginBorder(3, 3, 3, 3));
        interactionFigure.setLayoutManager((LayoutManager)new LeftToolbarLayout());
        interactionFigure.add((IFigure)this.interactionHeader);
        this.interactionLabelContainer = new RectangleFigure();
        this.interactionLabelContainer.setOutline(false);
        this.interactionLabelContainer.setFill(false);
        this.interactionLabelContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.interactionLabelContainer.add((IFigure)interactionFigure, 0);
        return this.interactionLabelContainer;
    }

    public WrappingLabel getNameLabel() {
        return this.interactionHeader;
    }

    public RectangleFigure getLabelContainer() {
        return this.interactionLabelContainer;
    }

    public RectangleFigure getContentFigure() {
        return this.interactionContentPane;
    }

    public ShapeCompartmentFigure getGMFContentContainer() {
        if (this.interactionContentPane.getChildren().size() > 0) {
            return (ShapeCompartmentFigure)this.interactionContentPane.getChildren().get(0);
        }
        return null;
    }

    private class ActivityLayoutManager
    extends AbstractLayout {
        private ActivityLayoutManager() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
            int minimumWith = 0;
            int minimumHeight = 0;
            if (ActivityAsInteractionFigure.this.getContentFigure().getChildren().size() > 0) {
                IFigure content = (IFigure)ActivityAsInteractionFigure.this.getContentFigure().getChildren().get(0);
                minimumWith = content.getPreferredSize().width + 50;
                minimumHeight = content.getPreferredSize().height + 50;
            }
            if (ActivityAsInteractionFigure.this.getNameLabel() != null) {
                if (ActivityAsInteractionFigure.this.getNameLabel().getPreferredSize().width > minimumWith) {
                    minimumWith = ActivityAsInteractionFigure.this.getNameLabel().getPreferredSize().width;
                }
                minimumHeight += ActivityAsInteractionFigure.this.getNameLabel().getPreferredSize().height;
            }
            if (ActivityAsInteractionFigure.this.getHeaderSingleExecution() != null && ActivityAsInteractionFigure.this.getHeaderSingleExecution().getBounds().getTopRight().x > minimumWith) {
                minimumWith = ActivityAsInteractionFigure.this.getHeaderSingleExecution().getBounds().getTopRight().x;
            }
            return new Dimension(minimumWith, minimumHeight);
        }

        public void layout(IFigure container) {
            List childrenList = container.getChildren();
            int i = 0;
            while (i < container.getChildren().size()) {
                IFigure currentFigure = (IFigure)childrenList.get(i);
                if (currentFigure.equals(ActivityAsInteractionFigure.this.getLabelContainer()) || currentFigure.equals(ActivityAsInteractionFigure.this.getContentFigure())) {
                    Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
                    bound.setSize(((IFigure)childrenList.get(i)).getPreferredSize());
                    bound.y = i > 0 ? ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1 : ActivityAsInteractionFigure.this.getBounds().y + 5;
                    ((IFigure)childrenList.get(i)).setBounds(bound);
                }
                ++i;
            }
            Rectangle lastRectangle = ActivityAsInteractionFigure.this.getContentFigure().getBounds();
            lastRectangle.height = ActivityAsInteractionFigure.this.getBounds().y + ActivityAsInteractionFigure.this.getBounds().height - lastRectangle.y;
            lastRectangle.x = container.getBounds().x;
            lastRectangle.width = ActivityAsInteractionFigure.this.getBounds().width;
            ActivityAsInteractionFigure.this.getContentFigure().setBounds(lastRectangle);
            if (ActivityAsInteractionFigure.this.getGMFContentContainer() != null) {
                ActivityAsInteractionFigure.this.getGMFContentContainer().setBounds(lastRectangle);
            }
            if (ActivityAsInteractionFigure.this.getStereotypePropertiesContent() != null) {
                Rectangle pscontainer = ActivityAsInteractionFigure.this.getStereotypePropertiesContent().getBounds().getCopy();
                if (ActivityAsInteractionFigure.this.getPostconditionFigure().getBounds().y + ActivityAsInteractionFigure.this.getPostconditionFigure().getBounds().height + 5 > pscontainer.y) {
                    pscontainer.y = ActivityAsInteractionFigure.this.getPostconditionFigure().getBounds().y + ActivityAsInteractionFigure.this.getPostconditionFigure().getBounds().height + 5;
                }
                ActivityAsInteractionFigure.this.getStereotypePropertiesContent().setBounds(pscontainer);
            }
        }
    }
}

