/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.common.helper.AlignmentLinkHelper;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;
import org.eclipse.papyrus.uml.diagram.menu.actions.AlignActionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAlignAction {
    private int alignment;
    private List<IGraphicalEditPart> selectedElements;
    private EditPart refEditPart;
    private PrecisionRectangle refBounds;
    private AlignActionHelper helper;

    public CustomAlignAction(int alignment, List<IGraphicalEditPart> selectedElements) {
        this.alignment = alignment;
        this.selectedElements = selectedElements;
        this.helper = new AlignActionHelper(alignment, selectedElements);
    }

    public Command getCommand() {
        CompoundCommand commands = new CompoundCommand("Alignment Commands");
        if (this.helper.isLinkSelection(this.selectedElements)) {
            AlignmentLinkHelper alignmentLinkHelper = new AlignmentLinkHelper(this.selectedElements, this.alignment);
            commands.add(alignmentLinkHelper.createCommand());
        } else if (this.helper.isAlignAllowed(this.selectedElements)) {
            this.refEditPart = this.helper.getRefEditPart();
            this.refBounds = LayoutUtils.getAbsolutePosition((EditPart)this.refEditPart);
            for (EditPart editPart : this.selectedElements) {
                PrecisionRectangle currentEPBounds;
                PrecisionRectangle newPosition;
                if (editPart.getSelected() != 1 || !this.helper.isPositionAllowed(editPart, newPosition = this.helper.getNewPosition(currentEPBounds = LayoutUtils.getAbsolutePosition((EditPart)editPart), this.refBounds))) continue;
                commands.add(this.getAlignmentCommand(editPart, newPosition));
            }
        } else {
            commands = null;
        }
        return commands;
    }

    private Command getAlignmentCommand(EditPart currentEP, PrecisionRectangle newPosition) {
        AlignmentRequest currentReq;
        Command curCommand = null;
        if (currentEP != null && (currentReq = this.getRequest(currentEP, newPosition)) != null) {
            curCommand = currentEP.getCommand((Request)currentReq);
        }
        return curCommand;
    }

    protected AlignmentRequest getRequest(EditPart currentEP, PrecisionRectangle newPosition) {
        AlignmentRequest alignReq = new AlignmentRequest((Object)"align");
        alignReq.setAlignment(this.alignment);
        alignReq.setAlignmentRectangle((Rectangle)newPosition);
        alignReq.setEditParts(currentEP);
        return alignReq;
    }
}

