/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStyleValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAlignmentAction {
    private int textAlignment;
    private List<IGraphicalEditPart> selectedElements;

    public TextAlignmentAction(int textAlignment, List<IGraphicalEditPart> selectedElements) {
        this.textAlignment = textAlignment;
        this.selectedElements = selectedElements;
    }

    public Command getCommand() {
        CompoundCommand cc = new CompoundCommand("Change value for text alignment");
        for (IGraphicalEditPart editPart : this.selectedElements) {
            if (!(editPart instanceof PapyrusLabelEditPart) || editPart.getModel() == null || ((PapyrusLabelEditPart)editPart).isLabelConstrained()) continue;
            View view = (View)editPart.getModel();
            CustomStyleValueCommand command = new CustomStyleValueCommand(view, (Object)this.literalPositionConstant(this.textAlignment), NotationPackage.eINSTANCE.getStringValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getStringValueStyle_StringValue(), "textAlignment");
            cc.append((Command)command);
        }
        if (!cc.isEmpty() && cc.canExecute()) {
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private String literalPositionConstant(int textAlignment) {
        String position;
        switch (textAlignment) {
            case 1: {
                position = "left";
                break;
            }
            case 2: {
                position = "center";
                break;
            }
            case 4: {
                position = "right";
                break;
            }
            default: {
                position = "left";
            }
        }
        return position;
    }
}

