/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;

public class AppliedStereotypeExternalNodeLabelEditPolicy
extends AppliedStereotypeLabelDisplayEditPolicy {
    protected View hostView = null;

    public AppliedStereotypeExternalNodeLabelEditPolicy() {
        this(null);
    }

    public AppliedStereotypeExternalNodeLabelEditPolicy(View hostView) {
        this.hostView = hostView;
    }

    public void activate() {
        EObject parent;
        View view = this.getView();
        if (view == null) {
            return;
        }
        super.activate();
        if (this.hostView == null && (parent = view.eContainer()) instanceof View) {
            this.hostView = (View)parent;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.hostView, (NotificationListener)this);
        this.refreshDisplay();
    }

    public void deactivate() {
        if (this.hostView != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostView, (NotificationListener)this);
        }
        super.deactivate();
    }

    public void refreshDisplay() {
        IFigure figure;
        super.refreshDisplay();
        if (this.getHost() instanceof IPapyrusEditPart && (figure = ((IPapyrusEditPart)this.getHost()).getPrimaryShape()) instanceof IPapyrusNodeUMLElementFigure) {
            this.refreshAppliedStereotypesProperties((IPapyrusNodeUMLElementFigure)figure);
        }
    }

    public String stereotypesToDisplay() {
        if (this.hostView == null) {
            return "";
        }
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)this.hostView);
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.hostView);
        if ("IconStereotype".equals(stereotypespresentationKind)) {
            return "";
        }
        String stereotypesToDisplayWithQN = AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)this.hostView);
        if (stereotypesToDisplayWithQN.length() == 0 && stereotypesToDisplay.length() == 0) {
            return "";
        }
        if ("VerticalStereo".equals(stereotypespresentationKind)) {
            return String.valueOf(Activator.ST_LEFT) + this.stereotypesToDisplay(String.valueOf(Activator.ST_RIGHT) + "\n" + Activator.ST_LEFT, stereotypesToDisplay, stereotypesToDisplayWithQN) + Activator.ST_RIGHT;
        }
        return String.valueOf(Activator.ST_LEFT) + this.stereotypesToDisplay(", ", stereotypesToDisplay, stereotypesToDisplayWithQN) + Activator.ST_RIGHT;
    }

    protected void refreshAppliedStereotypesProperties(IPapyrusNodeUMLElementFigure figure) {
        if (this.hostView == null) {
            return;
        }
        String stereotypesPropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)this.hostView);
        this.refreshAppliedStereotypesPropertiesInCompartment(stereotypesPropertiesToDisplay, figure);
        this.refreshAppliedStereotypesPropertiesInBrace(stereotypesPropertiesToDisplay, figure);
    }

    protected void refreshAppliedStereotypesPropertiesInCompartment(String stereotypesPropertiesToDisplay, IPapyrusNodeUMLElementFigure figure) {
        if (this.hostView == null) {
            return;
        }
        boolean displayInCompartment = AppliedStereotypeHelper.hasAppliedStereotypesPropertiesToDisplay((EModelElement)this.hostView, (String)"Compartment");
        if (displayInCompartment) {
            String todisplay = StereotypeUtil.getPropertiesValues((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement());
            figure.setStereotypePropertiesInCompartment(todisplay);
        } else {
            figure.setStereotypePropertiesInCompartment(null);
        }
    }

    protected void refreshAppliedStereotypesPropertiesInBrace(String stereotypesPropertiesToDisplay, IPapyrusNodeUMLElementFigure figure) {
        if (this.hostView == null) {
            return;
        }
        boolean displayInBrace = AppliedStereotypeHelper.hasAppliedStereotypesPropertiesToDisplay((EModelElement)this.hostView, (String)"With brace");
        if (displayInBrace) {
            String todisplay = StereotypeUtil.getPropertiesValuesInBrace((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement());
            figure.setStereotypePropertiesInBrace(todisplay);
        } else {
            figure.setStereotypePropertiesInBrace(null);
        }
    }

    protected void refreshStereotypeDisplay() {
        IFigure figure;
        if (this.getHost() instanceof IPapyrusEditPart && (figure = ((IPapyrusEditPart)this.getHost()).getPrimaryShape()) instanceof IPapyrusUMLElementFigure) {
            String stereotypesToDisplay = this.stereotypesToDisplay();
            ((IPapyrusUMLElementFigure)figure).setStereotypeDisplay(String.valueOf(this.tag) + stereotypesToDisplay, null);
        }
    }
}

