/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.synchronizeview.editpolicy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.synchronizeview.customization.ISynchroSemanticChild;
import org.eclipse.papyrus.uml.diagram.synchronizeview.customization.SynchroSemanticChildRegistry;
import org.eclipse.uml2.uml.Element;

public class SynchronizeViewEditPolicy
extends CanonicalEditPolicy {
    ISynchroSemanticChild synchroSemanticChild = null;
    EObject derivedSemanticHost = null;

    public void activate() {
        super.activate();
        this.synchroSemanticChild = SynchroSemanticChildRegistry.getInstance().getSynchroSemanticChild(this.getHost().getClass());
        if (this.synchroSemanticChild != null) {
            this.derivedSemanticHost = this.synchroSemanticChild.getSemanticEObjectToListen(this.getSemanticHost());
            if (this.derivedSemanticHost != null) {
                this.addListenerFilter("SYNCHRONIZE", (NotificationListener)this, this.derivedSemanticHost);
            }
        }
    }

    public boolean isEnabled() {
        if (this.getCanonicalStyle() == null) {
            return false;
        }
        return super.isEnabled();
    }

    protected List<EObject> getSemanticChildrenList() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Class<?> EditPart2 = this.getHost().getClass();
        ISynchroSemanticChild synchroSemanticChild = SynchroSemanticChildRegistry.getInstance().getSynchroSemanticChild(EditPart2);
        if (synchroSemanticChild != null) {
            ArrayList<EObject> ancestor = this.getAllEObjectAncestor();
            List<EObject> tmplist = synchroSemanticChild.getSynchroSemanticChild(this.getSemanticHost());
            for (EObject eObject : tmplist) {
                if (!ancestor.contains(eObject)) continue;
                return Collections.emptyList();
            }
            return tmplist;
        }
        if (this.getSemanticHost() instanceof Element) {
            result.addAll((Collection<EObject>)((Element)this.getSemanticHost()).getOwnedElements());
            return result;
        }
        return result;
    }

    protected ArrayList<EObject> getAllEObjectAncestor() {
        ArrayList<EObject> ancestor = new ArrayList<EObject>();
        EditPart currentEditPart = this.getHost();
        if (currentEditPart.getModel() instanceof View) {
            ancestor.add(((View)currentEditPart.getModel()).getElement());
        }
        while (currentEditPart.getParent() != null) {
            if (!((currentEditPart = currentEditPart.getParent()).getModel() instanceof View)) continue;
            ancestor.add(((View)currentEditPart.getModel()).getElement());
        }
        return ancestor;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.synchroSemanticChild != null && this.derivedSemanticHost == null && this.synchroSemanticChild.getSemanticEObjectToListen(this.getSemanticHost()) != null) {
            this.derivedSemanticHost = this.synchroSemanticChild.getSemanticEObjectToListen(this.getSemanticHost());
            this.addListenerFilter("SYNCHRONIZE", (NotificationListener)this, this.derivedSemanticHost);
        }
    }

    protected void refreshSemantic() {
        List<IAdaptable> createdViews = this.refreshSemanticChildrenByDrop();
        this.makeViewsImmutable(createdViews);
    }

    protected List<IAdaptable> refreshSemanticChildrenByDrop() {
        if (this.resolveSemanticElement() == null) {
            return Collections.emptyList();
        }
        List<View> viewChildren = this.getViewChildren();
        ArrayList<EObject> semanticChildren = new ArrayList<EObject>(this.getSemanticChildrenList());
        List orphaned = this.cleanCanonicalSemanticChildren(viewChildren, semanticChildren);
        boolean changed = false;
        if (!orphaned.isEmpty()) {
            changed = this.deleteViews(orphaned.iterator());
        }
        List createdViews = Collections.emptyList();
        if (!semanticChildren.isEmpty()) {
            createdViews = this.createViews(semanticChildren);
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        return createdViews;
    }

    protected Command getCreateViewCommand(CreateRequest request) {
        if (request instanceof CreateViewRequest) {
            CreateViewRequest createViewRequest = (CreateViewRequest)request;
            createViewRequest.getViewDescriptors();
            CompoundCommand compoundCommand = new CompoundCommand();
            for (CreateViewRequest.ViewDescriptor viewDescriptor : createViewRequest.getViewDescriptors()) {
                EObject element = (EObject)viewDescriptor.getElementAdapter().getAdapter(EObject.class);
                if (element == null) continue;
                ArrayList<EObject> elementToDrop = new ArrayList<EObject>();
                elementToDrop.add(element);
                DropObjectsRequest dropRequest = new DropObjectsRequest();
                dropRequest.setObjects(elementToDrop);
                dropRequest.setLocation(createViewRequest.getLocation());
                Command cmd = this.getHost().getCommand((Request)dropRequest);
                if (cmd == null || !cmd.canExecute()) continue;
                compoundCommand.add(cmd);
            }
            return compoundCommand;
        }
        Command cmd = super.getCreateViewCommand(request);
        return cmd;
    }

    protected boolean shouldDeleteView(View view) {
        return view instanceof Edge && view.getElement() == null;
    }

    protected List<View> getViewChildren() {
        List children = super.getViewChildren();
        children.addAll(((GraphicalEditPart)this.getHost()).getNotationView().getDiagram().getEdges());
        return children;
    }
}

