/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.AbstractTimelineLayoutPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.GeneralOrderingUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.RequestUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeElementUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomCompactLifelineCompartmentLayoutEditPolicy
extends AbstractTimelineLayoutPolicy {
    protected Command getMoveChildrenCommand(Request request) {
        if (RequestUtils.isChangeBoundsRequestFor(request, UMLPackage.eINSTANCE.getOccurrenceSpecification())) {
            return this.getMoveOccurrenceSpecificationsCommand(request);
        }
        return super.getMoveChildrenCommand(request);
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        if (RequestUtils.isChangeBoundsRequestFor((Request)request, UMLPackage.eINSTANCE.getStateInvariant())) {
            return this.getResizeStateInvariantsCommand(request);
        }
        return super.getResizeChildrenCommand(request);
    }

    /*
     * Unable to fully structure code
     */
    private Command getResizeStateInvariantsCommand(ChangeBoundsRequest request) {
        if (request.getResizeDirection() != 16) {
            return UnexecutableCommand.INSTANCE;
        }
        compoundCommand = new CompoundCommand(Messages.CustomCompactLifelineCompartmentLayoutEditPolicy_ResizeStateInvariant);
        lifelineEditPart = (CompactLifelineEditPartCN)this.getHost().getParent();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
        compartmentEditPart = (CompactLifelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId((EditPart)lifelineEditPart, 23);
        widthDelta = FigureUtils.scaleByZoom((Point)new Point((int)request.getSizeDelta().width, (int)0), (IFigure)lifelineEditPart.getFigure()).x;
        editPartsToResize = request.getEditParts();
        children = compartmentEditPart.getChildren();
        deltaX = 0;
        moved = false;
        i = 0;
        while (i < children.size()) {
            block8: {
                childEditPart = (EditPart)children.get(i);
                nextChildEditPart = null;
                if (i < children.size() - 1) {
                    nextChildEditPart = (EditPart)children.get(i + 1);
                }
                if (!((model = childEditPart.getModel()) instanceof Node)) break block8;
                childNode = (Node)model;
                v0 = move = deltaX != 0;
                if (OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(childEditPart)) {
                    v1 = move = move != false && nextChildEditPart instanceof CompactStateInvariantEditPartCN != false;
                }
                if (!move || TimeElementUtils.isTimeElementEditPart(childEditPart) || GeneralOrderingUtils.isGeneralOrderingEditPart(childEditPart)) ** GOTO lbl33
                layoutConstraint = childNode.getLayoutConstraint();
                if (!(layoutConstraint instanceof Location)) {
                    Activator.log.error("Expected a LayoutConstraint", (Throwable)new Exception());
                } else {
                    location = (Location)layoutConstraint;
                    newX = location.getX() + deltaX;
                    editingDomain = TransactionUtil.getEditingDomain((EObject)childNode);
                    compoundCommand.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, Messages.CustomCompactLifelineCompartmentLayoutEditPolicy_MoveElement, null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Location loc = NotationFactory.eINSTANCE.createLocation();
                            loc.setX(newX);
                            childNode.setLayoutConstraint((LayoutConstraint)loc);
                            return CommandResult.newOKCommandResult();
                        }
                    }));
                    moved = true;
lbl33:
                    // 2 sources

                    if (editPartsToResize.contains(childEditPart)) {
                        deltaX += widthDelta;
                    }
                }
            }
            ++i;
        }
        if (!moved) {
            return UnexecutableCommand.INSTANCE;
        }
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)lifelineEditPart));
        return compoundCommand;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        View childView = (View)child.getModel();
        int visualID = UMLVisualIDRegistry.getVisualID(childView);
        if (OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(visualID) || TimeElementUtils.isTimeElementEditPart(visualID) || GeneralOrderingUtils.isGeneralOrderingEditPart(visualID)) {
            return new NonResizableEditPolicyEx(){

                protected Command getMoveCommand(ChangeBoundsRequest request) {
                    ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
                    req.setEditParts(request.getEditParts());
                    req.setMoveDelta(request.getMoveDelta());
                    req.setSizeDelta(request.getSizeDelta());
                    req.setLocation(request.getLocation());
                    req.setExtendedData(request.getExtendedData());
                    return this.getHost().getParent().getCommand((Request)req);
                }
            };
        }
        return new ResizableShapeEditPolicy(){

            protected Command getResizeCommand(ChangeBoundsRequest request) {
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
                req.setEditParts(request.getEditParts());
                req.setMoveDelta(request.getMoveDelta());
                req.setSizeDelta(request.getSizeDelta());
                req.setLocation(request.getLocation());
                req.setExtendedData(request.getExtendedData());
                req.setResizeDirection(request.getResizeDirection());
                return this.getHost().getParent().getCommand((Request)req);
            }

            public boolean isDragAllowed() {
                return false;
            }
        };
    }

    private Command getMoveOccurrenceSpecificationsCommand(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomCompactLifelineCompartmentLayoutEditPolicy_MoveOccurrenceSpecification);
        CompactLifelineEditPartCN lifelineEditPart = (CompactLifelineEditPartCN)this.getHost().getParent();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
        CompactLifelineCompartmentEditPartCN timelineCompartmentEditPart = (CompactLifelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId((EditPart)lifelineEditPart, 23);
        View timelineCompartmentView = (View)timelineCompartmentEditPart.getModel();
        List editParts = changeBoundsRequest.getEditParts();
        ArrayList<Node> nodesToMove = new ArrayList<Node>();
        for (EditPart editPart : editParts) {
            Node node;
            Object model = editPart.getModel();
            if (!(model instanceof Node) || !((node = (Node)model).getElement() instanceof OccurrenceSpecification)) continue;
            nodesToMove.add(node);
        }
        for (Node node : nodesToMove) {
            int index = timelineCompartmentView.getChildren().indexOf((Object)node);
            if (index < 0) continue;
            compoundCommand.add(CustomCompactLifelineCompartmentLayoutEditPolicy.getMoveOccurrenceSpecificationCommand(node, FigureUtils.scaleByZoom((Point)changeBoundsRequest.getMoveDelta(), (IFigure)lifelineEditPart.getFigure()), timelineCompartmentView, index, nodesToMove));
        }
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)lifelineEditPart));
        return compoundCommand;
    }

    @Override
    protected int getOriginX() {
        return 100;
    }
}

